/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.scheduler.Schedulers;

public class StandardWebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(StandardWebSocketClient.class);
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final WebSocketContainer webSocketContainer;

    public StandardWebSocketClient() {
        this(ContainerProvider.getWebSocketContainer());
    }

    public StandardWebSocketClient(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public WebSocketContainer getWebSocketContainer() {
        return this.webSocketContainer;
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        return this.executeInternal(url, headers2, handler);
    }

    private Mono<Void> executeInternal(URI url, HttpHeaders requestHeaders, WebSocketHandler handler) {
        MonoProcessor completionMono = MonoProcessor.create();
        return Mono.fromCallable(() -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting to " + url);
            }
            List<String> protocols = handler.getSubProtocols();
            DefaultConfigurator configurator = new DefaultConfigurator(requestHeaders);
            StandardWebSocketHandlerAdapter endpoint = this.createEndpoint(url, handler, completionMono, configurator);
            ClientEndpointConfig config = this.createEndpointConfig(configurator, protocols);
            return this.webSocketContainer.connectToServer((Endpoint)endpoint, config, url);
        }).subscribeOn(Schedulers.boundedElastic()).then(completionMono);
    }

    private StandardWebSocketHandlerAdapter createEndpoint(URI url, WebSocketHandler handler, MonoProcessor<Void> completion, DefaultConfigurator configurator) {
        return new StandardWebSocketHandlerAdapter(handler, session -> this.createWebSocketSession((Session)session, this.createHandshakeInfo(url, configurator), completion));
    }

    private HandshakeInfo createHandshakeInfo(URI url, DefaultConfigurator configurator) {
        HttpHeaders responseHeaders = configurator.getResponseHeaders();
        String protocol = responseHeaders.getFirst("Sec-WebSocket-Protocol");
        return new HandshakeInfo(url, responseHeaders, Mono.empty(), protocol);
    }

    protected StandardWebSocketSession createWebSocketSession(Session session, HandshakeInfo info, MonoProcessor<Void> completion) {
        return new StandardWebSocketSession(session, info, this.bufferFactory, completion);
    }

    private ClientEndpointConfig createEndpointConfig(ClientEndpointConfig.Configurator configurator, List<String> subProtocols) {
        return ClientEndpointConfig.Builder.create().configurator(configurator).preferredSubprotocols(subProtocols).build();
    }

    protected DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    private static final class DefaultConfigurator
    extends ClientEndpointConfig.Configurator {
        private final HttpHeaders requestHeaders;
        private final HttpHeaders responseHeaders = new HttpHeaders();

        public DefaultConfigurator(HttpHeaders requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        public HttpHeaders getResponseHeaders() {
            return this.responseHeaders;
        }

        public void beforeRequest(Map<String, List<String>> requestHeaders) {
            requestHeaders.putAll(this.requestHeaders);
        }

        public void afterResponse(HandshakeResponse response) {
            response.getHeaders().forEach(this.responseHeaders::put);
        }
    }
}

