/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher.retry;

import feign.MethodMetadata;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.publisher.retry.OutOfRetriesException;
import reactivefeign.utils.FeignUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RetryPublisherHttpClient
implements PublisherHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryPublisherHttpClient.class);
    private final String feignMethodTag;
    protected final PublisherHttpClient publisherClient;
    protected final Function<Flux<Throwable>, Flux<Throwable>> retryFunction;

    protected RetryPublisherHttpClient(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
        this.publisherClient = publisherClient;
        this.feignMethodTag = FeignUtils.methodTag(methodMetadata);
        this.retryFunction = RetryPublisherHttpClient.wrapWithLog(retryFunction, this.feignMethodTag);
    }

    protected Function<Flux<Throwable>, Flux<Throwable>> wrapWithOutOfRetries(Function<Flux<Throwable>, Flux<Throwable>> retryFunction, ReactiveHttpRequest request) {
        return throwableFlux -> ((Flux)retryFunction.apply((Flux<Throwable>)throwableFlux)).onErrorResume(throwable -> Mono.just(new OutOfRetriesWrapper((Throwable)throwable, request))).zipWith(Flux.range(1, Integer.MAX_VALUE), (throwable, index) -> {
            if (throwable instanceof OutOfRetriesWrapper) {
                if (index == 1) {
                    throw Exceptions.propagate(throwable.getCause());
                }
                logger.error("[{}]---> USED ALL RETRIES", (Object)this.feignMethodTag, throwable);
                throw Exceptions.propagate(new OutOfRetriesException(throwable.getCause(), request));
            }
            return throwable;
        });
    }

    protected static Function<Flux<Throwable>, Flux<Throwable>> wrapWithLog(Function<Flux<Throwable>, Flux<Throwable>> retryFunction, String feignMethodTag) {
        return throwableFlux -> ((Flux)retryFunction.apply((Flux<Throwable>)throwableFlux)).doOnNext(throwable -> {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]---> RETRYING on error", (Object)feignMethodTag, throwable);
            }
        });
    }

    private static class OutOfRetriesWrapper
    extends ReactiveFeignException {
        public OutOfRetriesWrapper(Throwable cause, ReactiveHttpRequest request) {
            super(cause, request);
        }
    }
}

