/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange2, final HttpContent content, final Callback callback) {
        HeadersPromise promise;
        HeadersFrame headersFrame;
        final HttpRequest request = exchange2.getRequest();
        String path2 = this.relativize(request.getPath());
        HttpURI uri = HttpURI.createHttpURI(request.getScheme(), request.getHost(), request.getPort(), path2, null, request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        final Supplier<HttpFields> trailerSupplier = request.getTrailers();
        metaData.setTrailerSupplier(trailerSupplier);
        if (content.hasContent()) {
            headersFrame = new HeadersFrame(metaData, null, false);
            promise = new HeadersPromise(request, callback){

                @Override
                public void succeeded(Stream stream) {
                    super.succeeded(stream);
                    if (HttpSenderOverHTTP2.this.expects100Continue(request)) {
                        callback.succeeded();
                    } else {
                        boolean advanced = content.advance();
                        boolean lastContent = content.isLast();
                        if (advanced || lastContent) {
                            HttpSenderOverHTTP2.this.sendContent(stream, content, trailerSupplier, callback);
                        } else {
                            callback.succeeded();
                        }
                    }
                }
            };
        } else {
            final HttpFields trailers = trailerSupplier == null ? null : trailerSupplier.get();
            final boolean endStream = trailers == null || trailers.size() == 0;
            headersFrame = new HeadersFrame(metaData, null, endStream);
            promise = new HeadersPromise(request, callback){

                @Override
                public void succeeded(Stream stream) {
                    super.succeeded(stream);
                    if (endStream) {
                        callback.succeeded();
                    } else {
                        HttpSenderOverHTTP2.this.sendTrailers(stream, trailers, callback);
                    }
                }
            };
        }
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        channel.getSession().newStream(headersFrame, promise, channel.getStreamListener());
    }

    private String relativize(String path2) {
        try {
            String result = path2;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path2, new Object[0]);
            }
            return path2;
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange2, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            Supplier<HttpFields> trailerSupplier = exchange2.getRequest().getTrailers();
            this.sendContent(stream, content, trailerSupplier, callback);
        }
    }

    private void sendContent(Stream stream, HttpContent content, Supplier<HttpFields> trailerSupplier, Callback callback) {
        boolean lastContent = content.isLast();
        HttpFields trailers = null;
        boolean endStream = false;
        if (lastContent) {
            trailers = trailerSupplier == null ? null : trailerSupplier.get();
            endStream = trailers == null || trailers.size() == 0;
        }
        DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), endStream);
        HttpFields fTrailers = trailers;
        stream.data(dataFrame, endStream || !lastContent ? callback : Callback.from(() -> this.sendTrailers(stream, fTrailers, callback), callback::failed));
    }

    private void sendTrailers(Stream stream, HttpFields trailers, Callback callback) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers);
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }

    private class HeadersPromise
    implements Promise<Stream> {
        private final HttpRequest request;
        private final Callback callback;

        private HeadersPromise(HttpRequest request, Callback callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void succeeded(Stream stream) {
            HttpChannelOverHTTP2 channel = HttpSenderOverHTTP2.this.getHttpChannel();
            channel.setStream(stream);
            ((IStream)stream).setAttachment(channel);
            long idleTimeout = this.request.getIdleTimeout();
            if (idleTimeout >= 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
        }

        @Override
        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

