/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class TrailingSlashFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String path2 = this.getRequestPathFrom(httpServletRequest);
        StatusAndRedirectExposingHttpServletResponse wrappedResponse = new StatusAndRedirectExposingHttpServletResponse((HttpServletResponse)response, path2, httpServletRequest);
        chain.doFilter(request, wrappedResponse);
    }

    private String getRequestPathFrom(HttpServletRequest httpServletRequest) throws ServletException {
        try {
            String fullPath = new URI(URLEncoder.encode(httpServletRequest.getRequestURI(), "utf-8")).getPath();
            String pathWithoutContext = fullPath.substring(httpServletRequest.getContextPath().length());
            return URLDecoder.decode(pathWithoutContext, "utf-8");
        }
        catch (URISyntaxException e) {
            throw new ServletException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void destroy() {
    }

    private static class StatusAndRedirectExposingHttpServletResponse
    extends HttpServletResponseWrapper {
        private String path;
        private HttpServletRequest request;

        public StatusAndRedirectExposingHttpServletResponse(HttpServletResponse response, String path2, HttpServletRequest request) {
            super(response);
            this.path = path2;
            this.request = request;
        }

        @Override
        public void sendRedirect(String location) throws IOException {
            if (location.contains(this.path)) {
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(this.getPathPartFromLocation(location));
                try {
                    dispatcher.forward(this.request, this);
                }
                catch (ServletException se) {
                    throw new IOException(se);
                }
            }
        }

        private String getPathPartFromLocation(String location) throws IOException {
            URL url = new URL(location);
            return url.getPath();
        }
    }
}

