/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.InternalPathPatternParser;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PatternParseException;

public class PathPatternParser {
    private static final Log logger = LogFactory.getLog(PathPatternParser.class);
    private boolean matchOptionalTrailingSeparator = true;
    private boolean caseSensitive = true;
    private PathContainer.Options pathOptions = PathContainer.Options.HTTP_PATH;

    public void setMatchOptionalTrailingSeparator(boolean matchOptionalTrailingSeparator) {
        this.matchOptionalTrailingSeparator = matchOptionalTrailingSeparator;
    }

    public boolean isMatchOptionalTrailingSeparator() {
        return this.matchOptionalTrailingSeparator;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPathOptions(PathContainer.Options pathOptions) {
        this.pathOptions = pathOptions;
    }

    public PathContainer.Options getPathOptions() {
        return this.pathOptions;
    }

    public PathPattern parse(String pathPattern) throws PatternParseException {
        int wildcardIndex = pathPattern.indexOf("**" + this.pathOptions.separator());
        if (wildcardIndex != -1 && wildcardIndex != pathPattern.length() - 3) {
            logger.warn("'**' patterns are not supported in the middle of patterns and will be rejected in the future. Consider using '*' instead for matching a single path segment.");
        }
        return new InternalPathPatternParser(this).parse(pathPattern);
    }
}

