/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class EqualToXmlPattern
extends StringValuePattern {
    private static List<ComparisonType> COUNTED_COMPARISONS = ImmutableList.of(ComparisonType.ELEMENT_TAG_NAME, ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_LOOKUP, new ComparisonType[]{ComparisonType.ATTR_NAME_LOOKUP});
    private final Document xmlDocument;
    private final Boolean enablePlaceholders;
    private final String placeholderOpeningDelimiterRegex;
    private final String placeholderClosingDelimiterRegex;
    private final DifferenceEvaluator diffEvaluator;
    private static final DifferenceEvaluator IGNORE_UNCOUNTED_COMPARISONS = new DifferenceEvaluator(){

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    };

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        this(expectedValue, null, null, null);
    }

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue, @JsonProperty(value="enablePlaceholders") Boolean enablePlaceholders, @JsonProperty(value="placeholderOpeningDelimiterRegex") String placeholderOpeningDelimiterRegex, @JsonProperty(value="placeholderClosingDelimiterRegex") String placeholderClosingDelimiterRegex) {
        super(expectedValue);
        this.xmlDocument = Xml.read(expectedValue);
        this.enablePlaceholders = enablePlaceholders;
        this.placeholderOpeningDelimiterRegex = placeholderOpeningDelimiterRegex;
        this.placeholderClosingDelimiterRegex = placeholderClosingDelimiterRegex;
        this.diffEvaluator = enablePlaceholders != null && enablePlaceholders != false ? DifferenceEvaluators.chain(IGNORE_UNCOUNTED_COMPARISONS, new PlaceholderDifferenceEvaluator(placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex)) : IGNORE_UNCOUNTED_COMPARISONS;
    }

    public String getEqualToXml() {
        return (String)this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint((String)this.getValue());
    }

    public Boolean isEnablePlaceholders() {
        return this.enablePlaceholders;
    }

    public String getPlaceholderOpeningDelimiterRegex() {
        return this.placeholderOpeningDelimiterRegex;
    }

    public String getPlaceholderClosingDelimiterRegex() {
        return this.placeholderClosingDelimiterRegex;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                try {
                    Diff diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withNodeMatcher(new OrderInvariantNodeMatcher()).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                if (Strings.isNullOrEmpty(value)) {
                    return 1.0;
                }
                final AtomicInteger totalComparisons = new AtomicInteger(0);
                final AtomicInteger differences = new AtomicInteger(0);
                Diff diff = null;
                try {
                    diff = DiffBuilder.compare(Input.from(EqualToXmlPattern.this.expectedValue)).withTest(value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withComparisonListeners(new ComparisonListener(){

                        @Override
                        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                            if (COUNTED_COMPARISONS.contains((Object)comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                                totalComparisons.incrementAndGet();
                                if (outcome == ComparisonResult.DIFFERENT) {
                                    differences.incrementAndGet();
                                }
                            }
                        }
                    }).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return 1.0;
                }
                LocalNotifier.notifier().info(Joiner.on("\n").join(diff.getDifferences()));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }

    private static final class OrderInvariantNodeMatcher
    extends DefaultNodeMatcher {
        private static final Comparator<Node> COMPARATOR = new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                return node1.getLocalName().compareTo(node2.getLocalName());
            }
        };

        private OrderInvariantNodeMatcher() {
        }

        @Override
        public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
            return super.match(OrderInvariantNodeMatcher.sort(controlNodes), OrderInvariantNodeMatcher.sort(testNodes));
        }

        private static Iterable<Node> sort(Iterable<Node> nodes) {
            return FluentIterable.from(nodes).toSortedList(COMPARATOR);
        }
    }
}

