/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.util.ExceptionsUtils;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.CompositeSubscription;

public final class OnSubscribeFlatMapCompletable<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final Func1<? super T, ? extends Completable> mapper;
    final boolean delayErrors;
    final int maxConcurrency;

    public OnSubscribeFlatMapCompletable(Observable<T> source, Func1<? super T, ? extends Completable> mapper, boolean delayErrors, int maxConcurrency) {
        if (mapper == null) {
            throw new NullPointerException("mapper is null");
        }
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        FlatMapCompletableSubscriber<? super T> parent = new FlatMapCompletableSubscriber<T>(child, this.mapper, this.delayErrors, this.maxConcurrency);
        child.add(parent);
        child.add(parent.set);
        this.source.unsafeSubscribe(parent);
    }

    static final class FlatMapCompletableSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<? super T, ? extends Completable> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicInteger wip;
        final CompositeSubscription set;
        final AtomicReference<Throwable> errors;

        FlatMapCompletableSubscriber(Subscriber<? super T> actual, Func1<? super T, ? extends Completable> mapper, boolean delayErrors, int maxConcurrency) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.wip = new AtomicInteger(1);
            this.errors = new AtomicReference();
            this.set = new CompositeSubscription();
            this.request(maxConcurrency != Integer.MAX_VALUE ? (long)maxConcurrency : Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            Completable c;
            try {
                c = this.mapper.call(t);
                if (c == null) {
                    throw new NullPointerException("The mapper returned a null Completable");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
                return;
            }
            InnerSubscriber inner = new InnerSubscriber();
            this.set.add(inner);
            this.wip.getAndIncrement();
            c.unsafeSubscribe(inner);
        }

        @Override
        public void onError(Throwable e) {
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e);
                this.onCompleted();
            } else {
                this.set.unsubscribe();
                if (this.errors.compareAndSet(null, e)) {
                    this.actual.onError(ExceptionsUtils.terminate(this.errors));
                } else {
                    RxJavaHooks.onError(e);
                }
            }
        }

        @Override
        public void onCompleted() {
            this.done();
        }

        boolean done() {
            if (this.wip.decrementAndGet() == 0) {
                Throwable ex = ExceptionsUtils.terminate(this.errors);
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onCompleted();
                }
                return true;
            }
            return false;
        }

        public void innerError(InnerSubscriber inner, Throwable e) {
            this.set.remove(inner);
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e);
                if (!this.done() && this.maxConcurrency != Integer.MAX_VALUE) {
                    this.request(1L);
                }
            } else {
                this.set.unsubscribe();
                this.unsubscribe();
                if (this.errors.compareAndSet(null, e)) {
                    this.actual.onError(ExceptionsUtils.terminate(this.errors));
                } else {
                    RxJavaHooks.onError(e);
                }
            }
        }

        public void innerComplete(InnerSubscriber inner) {
            this.set.remove(inner);
            if (!this.done() && this.maxConcurrency != Integer.MAX_VALUE) {
                this.request(1L);
            }
        }

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements CompletableSubscriber,
        Subscription {
            private static final long serialVersionUID = -8588259593722659900L;

            InnerSubscriber() {
            }

            @Override
            public void unsubscribe() {
                Subscription s2 = this.getAndSet(this);
                if (s2 != null && s2 != this) {
                    s2.unsubscribe();
                }
            }

            @Override
            public boolean isUnsubscribed() {
                return this.get() == this;
            }

            @Override
            public void onCompleted() {
                FlatMapCompletableSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapCompletableSubscriber.this.innerError(this, e);
            }

            @Override
            public void onSubscribe(Subscription d) {
                if (!this.compareAndSet(null, d)) {
                    d.unsubscribe();
                    if (this.get() != this) {
                        RxJavaHooks.onError(new IllegalStateException("Subscription already set!"));
                    }
                }
            }
        }
    }
}

