/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;

public class InetSocketAddressUtil {
    public static InetSocketAddress createUnresolved(String hostname, int port) {
        return InetSocketAddressUtil.createInetSocketAddress(hostname, port, false);
    }

    public static InetSocketAddress createResolved(String hostname, int port) {
        return InetSocketAddressUtil.createInetSocketAddress(hostname, port, true);
    }

    public static InetSocketAddress createInetSocketAddress(String hostname, int port, boolean resolve) {
        InetSocketAddress inetAddressForIpString = InetSocketAddressUtil.createForIpString(hostname, port);
        if (inetAddressForIpString != null) {
            return inetAddressForIpString;
        }
        return resolve ? new InetSocketAddress(hostname, port) : InetSocketAddress.createUnresolved(hostname, port);
    }

    @Nullable
    private static InetSocketAddress createForIpString(String hostname, int port) {
        InetAddress inetAddressForIpString = InetSocketAddressUtil.attemptParsingIpString(hostname);
        if (inetAddressForIpString != null) {
            return new InetSocketAddress(inetAddressForIpString, port);
        }
        return null;
    }

    public static InetSocketAddress replaceWithResolved(InetSocketAddress inetSocketAddress) {
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        if (!(inetSocketAddress = InetSocketAddressUtil.replaceUnresolvedNumericIp(inetSocketAddress)).isUnresolved()) {
            return inetSocketAddress;
        }
        return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }

    public static InetSocketAddress replaceUnresolvedNumericIp(InetSocketAddress inetSocketAddress) {
        if (!inetSocketAddress.isUnresolved()) {
            return inetSocketAddress;
        }
        InetSocketAddress inetAddressForIpString = InetSocketAddressUtil.createForIpString(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        if (inetAddressForIpString != null) {
            return inetAddressForIpString;
        }
        return inetSocketAddress;
    }

    @Nullable
    private static InetAddress attemptParsingIpString(String hostname) {
        byte[] ipAddressBytes = NetUtil.createByteArrayFromIpAddressString(hostname);
        if (ipAddressBytes != null) {
            try {
                if (ipAddressBytes.length == 4) {
                    return Inet4Address.getByAddress(ipAddressBytes);
                }
                return Inet6Address.getByAddress(null, ipAddressBytes, -1);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static InetSocketAddress parseAddress(String address, int defaultPort) {
        int ipV6HostSeparatorIdx;
        int separatorIdx = address.lastIndexOf(58);
        if (separatorIdx > (ipV6HostSeparatorIdx = address.lastIndexOf(93)) && (separatorIdx == address.indexOf(58) || ipV6HostSeparatorIdx > -1)) {
            String port = address.substring(separatorIdx + 1);
            if (port.chars().allMatch(Character::isDigit)) {
                return InetSocketAddressUtil.createUnresolved(address.substring(0, separatorIdx), Integer.parseInt(port));
            }
            return InetSocketAddressUtil.createUnresolved(address.substring(0, separatorIdx), defaultPort);
        }
        return InetSocketAddressUtil.createUnresolved(address, defaultPort);
    }
}

