/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.scripting.support.StandardScriptEvalException;
import org.springframework.scripting.support.StandardScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.script.RenderingContext;
import org.springframework.web.reactive.result.view.script.ScriptTemplateConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ScriptTemplateView
extends AbstractUrlBasedView {
    private static final String DEFAULT_RESOURCE_LOADER_PATH = "classpath:";
    @Nullable
    private ScriptEngine engine;
    @Nullable
    private Supplier<ScriptEngine> engineSupplier;
    @Nullable
    private String engineName;
    @Nullable
    private Boolean sharedEngine;
    @Nullable
    private String[] scripts;
    @Nullable
    private String renderObject;
    @Nullable
    private String renderFunction;
    @Nullable
    private String[] resourceLoaderPaths;
    @Nullable
    private volatile ScriptEngineManager scriptEngineManager;

    public ScriptTemplateView() {
    }

    public ScriptTemplateView(String url) {
        super(url);
    }

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public void setEngineSupplier(Supplier<ScriptEngine> engineSupplier) {
        this.engineSupplier = engineSupplier;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setSharedEngine(Boolean sharedEngine) {
        this.sharedEngine = sharedEngine;
    }

    public void setScripts(String ... scripts) {
        this.scripts = scripts;
    }

    public void setRenderObject(String renderObject) {
        this.renderObject = renderObject;
    }

    public void setRenderFunction(String functionName) {
        this.renderFunction = functionName;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        String[] paths = StringUtils.commaDelimitedListToStringArray(resourceLoaderPath);
        this.resourceLoaderPaths = new String[paths.length + 1];
        this.resourceLoaderPaths[0] = "";
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path2 = paths[i2];
            if (!path2.endsWith("/") && !path2.endsWith(":")) {
                path2 = path2 + "/";
            }
            this.resourceLoaderPaths[i2 + 1] = path2;
        }
    }

    @Override
    public void setApplicationContext(@Nullable ApplicationContext context) {
        super.setApplicationContext(context);
        ScriptTemplateConfig viewConfig = this.autodetectViewConfig();
        if (this.engine == null && viewConfig.getEngine() != null) {
            this.engine = viewConfig.getEngine();
        }
        if (this.engineSupplier == null && viewConfig.getEngineSupplier() != null) {
            this.engineSupplier = viewConfig.getEngineSupplier();
        }
        if (this.engineName == null && viewConfig.getEngineName() != null) {
            this.engineName = viewConfig.getEngineName();
        }
        if (this.scripts == null && viewConfig.getScripts() != null) {
            this.scripts = viewConfig.getScripts();
        }
        if (this.renderObject == null && viewConfig.getRenderObject() != null) {
            this.renderObject = viewConfig.getRenderObject();
        }
        if (this.renderFunction == null && viewConfig.getRenderFunction() != null) {
            this.renderFunction = viewConfig.getRenderFunction();
        }
        if (viewConfig.getCharset() != null) {
            this.setDefaultCharset(viewConfig.getCharset());
        }
        if (this.resourceLoaderPaths == null) {
            String resourceLoaderPath = viewConfig.getResourceLoaderPath();
            this.setResourceLoaderPath(resourceLoaderPath != null ? resourceLoaderPath : DEFAULT_RESOURCE_LOADER_PATH);
        }
        if (this.sharedEngine == null && viewConfig.isSharedEngine() != null) {
            this.sharedEngine = viewConfig.isSharedEngine();
        }
        int engineCount = 0;
        if (this.engine != null) {
            ++engineCount;
        }
        if (this.engineSupplier != null) {
            ++engineCount;
        }
        if (this.engineName != null) {
            ++engineCount;
        }
        Assert.isTrue(engineCount == 1, "You should define either 'engine', 'engineSupplier' or 'engineName'.");
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            Assert.isTrue(this.engine == null, "When 'sharedEngine' is set to false, you should specify the script engine using 'engineName' or 'engineSupplier' , not 'engine'.");
        } else if (this.engine != null) {
            this.loadScripts(this.engine);
        } else if (this.engineName != null) {
            this.setEngine(this.createEngineFromName(this.engineName));
        } else {
            this.setEngine(this.createEngineFromSupplier());
        }
        if (this.renderFunction != null && this.engine != null) {
            Assert.isInstanceOf(Invocable.class, (Object)this.engine, "ScriptEngine must implement Invocable when 'renderFunction' is specified");
        }
    }

    protected ScriptEngine getEngine() {
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            if (this.engineName != null) {
                return this.createEngineFromName(this.engineName);
            }
            return this.createEngineFromSupplier();
        }
        Assert.state(this.engine != null, "No shared engine available");
        return this.engine;
    }

    protected ScriptEngine createEngineFromName(String engineName) {
        ScriptEngineManager scriptEngineManager = this.scriptEngineManager;
        if (scriptEngineManager == null) {
            this.scriptEngineManager = scriptEngineManager = new ScriptEngineManager(this.obtainApplicationContext().getClassLoader());
        }
        ScriptEngine engine = StandardScriptUtils.retrieveEngineByName((ScriptEngineManager)scriptEngineManager, (String)engineName);
        this.loadScripts(engine);
        return engine;
    }

    private ScriptEngine createEngineFromSupplier() {
        Assert.state(this.engineSupplier != null, "No engine supplier available");
        ScriptEngine engine = this.engineSupplier.get();
        if (this.renderFunction != null) {
            Assert.isInstanceOf(Invocable.class, (Object)engine, "ScriptEngine must implement Invocable when 'renderFunction' is specified");
        }
        this.loadScripts(engine);
        return engine;
    }

    protected void loadScripts(ScriptEngine engine) {
        if (!ObjectUtils.isEmpty(this.scripts)) {
            for (String script : this.scripts) {
                Resource resource = this.getResource(script);
                if (resource == null) {
                    throw new IllegalStateException("Script resource [" + script + "] not found");
                }
                try {
                    engine.eval(new InputStreamReader(resource.getInputStream()));
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to evaluate script [" + script + "]", ex);
                }
            }
        }
    }

    @Nullable
    protected Resource getResource(String location) {
        if (this.resourceLoaderPaths != null) {
            for (String path2 : this.resourceLoaderPaths) {
                Resource resource = this.obtainApplicationContext().getResource(path2 + location);
                if (!resource.exists()) continue;
                return resource;
            }
        }
        return null;
    }

    protected ScriptTemplateConfig autodetectViewConfig() throws BeansException {
        try {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), ScriptTemplateConfig.class, true, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single ScriptTemplateConfig bean in the current web application context or the parent root context: ScriptTemplateConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        String url = this.getUrl();
        Assert.state(url != null, "'url' not set");
        return this.getResource(url) != null;
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> model, @Nullable MediaType contentType2, ServerWebExchange exchange2) {
        return exchange2.getResponse().writeWith(Mono.fromCallable(() -> {
            try {
                Object html;
                ScriptEngine engine = this.getEngine();
                String url = this.getUrl();
                Assert.state(url != null, "'url' not set");
                String template = this.getTemplate(url);
                Function<String, String> templateLoader = path2 -> {
                    try {
                        return this.getTemplate((String)path2);
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                };
                Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange2.getLocaleContext());
                RenderingContext context = new RenderingContext(this.obtainApplicationContext(), locale, templateLoader, url);
                if (this.renderFunction == null) {
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.putAll((Map<? extends String, ? extends Object>)model);
                    model.put("renderingContext", context);
                    html = engine.eval(template, (Bindings)bindings);
                } else if (this.renderObject != null) {
                    Object thiz = engine.eval(this.renderObject);
                    html = ((Invocable)((Object)engine)).invokeMethod(thiz, this.renderFunction, template, model, context);
                } else {
                    html = ((Invocable)((Object)engine)).invokeFunction(this.renderFunction, template, model, context);
                }
                byte[] bytes = String.valueOf(html).getBytes(StandardCharsets.UTF_8);
                return exchange2.getResponse().bufferFactory().wrap(bytes);
            }
            catch (ScriptException ex) {
                throw new IllegalStateException("Failed to render script template", (Throwable)new StandardScriptEvalException(ex));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to render script template", ex);
            }
        }));
    }

    protected String getTemplate(String path2) throws IOException {
        Resource resource = this.getResource(path2);
        if (resource == null) {
            throw new IllegalStateException("Template resource [" + path2 + "] not found");
        }
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), this.getDefaultCharset());
        return FileCopyUtils.copyToString(reader);
    }
}

