/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.openjdk.jmh.profile.AsyncProfiler;
import org.openjdk.jmh.profile.ClassloaderProfiler;
import org.openjdk.jmh.profile.CompilerProfiler;
import org.openjdk.jmh.profile.DTraceAsmProfiler;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.profile.HotspotClassloadingProfiler;
import org.openjdk.jmh.profile.HotspotCompilationProfiler;
import org.openjdk.jmh.profile.HotspotMemoryProfiler;
import org.openjdk.jmh.profile.HotspotRuntimeProfiler;
import org.openjdk.jmh.profile.HotspotThreadProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.JavaFlightRecorderProfiler;
import org.openjdk.jmh.profile.LinuxPerfAsmProfiler;
import org.openjdk.jmh.profile.LinuxPerfC2CProfiler;
import org.openjdk.jmh.profile.LinuxPerfNormProfiler;
import org.openjdk.jmh.profile.LinuxPerfProfiler;
import org.openjdk.jmh.profile.PausesProfiler;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.SafepointsProfiler;
import org.openjdk.jmh.profile.StackProfiler;
import org.openjdk.jmh.profile.WinPerfAsmProfiler;
import org.openjdk.jmh.runner.options.ProfilerConfig;

public class ProfilerFactory {
    private static final Map<String, Class<? extends Profiler>> BUILT_IN = new TreeMap<String, Class<? extends Profiler>>();

    public static Profiler getProfilerOrException(ProfilerConfig cfg) throws ProfilerException {
        try {
            return ProfilerFactory.getProfiler(cfg);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProfilerException) {
                throw (ProfilerException)e.getCause();
            }
            throw new ProfilerException(e);
        }
        catch (ProfilerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProfilerException(e);
        }
    }

    private static Profiler getProfilerOrNull(ProfilerConfig cfg) {
        try {
            return ProfilerFactory.getProfiler(cfg);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Profiler getProfiler(ProfilerConfig cfg) throws Exception {
        String desc = cfg.getKlass();
        Class<? extends Profiler> builtIn = BUILT_IN.get(desc);
        if (builtIn != null) {
            return ProfilerFactory.instantiate(cfg, builtIn);
        }
        List<Class<? extends Profiler>> profilers = ProfilerFactory.getDiscoveredProfilers();
        for (Class clazz : profilers) {
            if (!clazz.getCanonicalName().equals(desc)) continue;
            return ProfilerFactory.instantiate(cfg, clazz);
        }
        Class<?> klass = Class.forName(desc);
        return ProfilerFactory.instantiate(cfg, klass);
    }

    private static Profiler instantiate(ProfilerConfig cfg, Class<? extends Profiler> p) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            return p.getConstructor(String.class).newInstance(cfg.getOpts());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return p.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalStateException("Cannot instantiate profiler");
            }
        }
    }

    public static List<ExternalProfiler> getSupportedExternal(Collection<ProfilerConfig> cfg) {
        ArrayList<ExternalProfiler> profilers = new ArrayList<ExternalProfiler>();
        for (ProfilerConfig p : cfg) {
            Profiler prof = ProfilerFactory.getProfilerOrNull(p);
            if (!(prof instanceof ExternalProfiler)) continue;
            profilers.add((ExternalProfiler)prof);
        }
        return profilers;
    }

    public static List<InternalProfiler> getSupportedInternal(Collection<ProfilerConfig> cfg) {
        ArrayList<InternalProfiler> profilers = new ArrayList<InternalProfiler>();
        for (ProfilerConfig p : cfg) {
            Profiler prof = ProfilerFactory.getProfilerOrNull(p);
            if (!(prof instanceof InternalProfiler)) continue;
            profilers.add((InternalProfiler)prof);
        }
        return profilers;
    }

    public static void listProfilers(PrintStream out) {
        Profiler prof;
        int maxLen = 0;
        for (String string : BUILT_IN.keySet()) {
            maxLen = Math.max(maxLen, string.length());
        }
        for (Class clazz : ProfilerFactory.getDiscoveredProfilers()) {
            maxLen = Math.max(maxLen, clazz.getCanonicalName().length());
        }
        maxLen += 2;
        StringBuilder supported = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : BUILT_IN.keySet()) {
            try {
                prof = ProfilerFactory.getProfilerOrException(new ProfilerConfig(string, ""));
                supported.append(String.format("%" + maxLen + "s: %s %s\n", string, prof.getDescription(), ""));
            }
            catch (ProfilerException e) {
                stringBuilder.append(String.format("%" + maxLen + "s: %s %s\n", string, "<none>", ""));
                stringBuilder.append(e.getMessage());
                stringBuilder.append("\n");
            }
        }
        for (Class clazz : ProfilerFactory.getDiscoveredProfilers()) {
            try {
                prof = ProfilerFactory.getProfilerOrException(new ProfilerConfig(clazz.getCanonicalName(), ""));
                supported.append(String.format("%" + maxLen + "s: %s %s\n", clazz.getCanonicalName(), prof.getDescription(), "(discovered)"));
            }
            catch (ProfilerException e) {
                stringBuilder.append(String.format("%" + maxLen + "s: %s %s\n", clazz, clazz.getCanonicalName(), ""));
                stringBuilder.append(e.getMessage());
                stringBuilder.append("\n");
            }
        }
        if (!supported.toString().isEmpty()) {
            out.println("Supported profilers:\n" + supported.toString());
        }
        if (!stringBuilder.toString().isEmpty()) {
            out.println("Unsupported profilers:\n" + stringBuilder.toString());
        }
    }

    private static List<Class<? extends Profiler>> getDiscoveredProfilers() {
        ArrayList<Class<? extends Profiler>> profs = new ArrayList<Class<? extends Profiler>>();
        for (Profiler s2 : ServiceLoader.load(Profiler.class)) {
            profs.add(s2.getClass());
        }
        return profs;
    }

    static {
        BUILT_IN.put("async", AsyncProfiler.class);
        BUILT_IN.put("cl", ClassloaderProfiler.class);
        BUILT_IN.put("comp", CompilerProfiler.class);
        BUILT_IN.put("gc", GCProfiler.class);
        BUILT_IN.put("hs_cl", HotspotClassloadingProfiler.class);
        BUILT_IN.put("hs_comp", HotspotCompilationProfiler.class);
        BUILT_IN.put("hs_gc", HotspotMemoryProfiler.class);
        BUILT_IN.put("hs_rt", HotspotRuntimeProfiler.class);
        BUILT_IN.put("hs_thr", HotspotThreadProfiler.class);
        BUILT_IN.put("jfr", JavaFlightRecorderProfiler.class);
        BUILT_IN.put("stack", StackProfiler.class);
        BUILT_IN.put("perf", LinuxPerfProfiler.class);
        BUILT_IN.put("perfnorm", LinuxPerfNormProfiler.class);
        BUILT_IN.put("perfasm", LinuxPerfAsmProfiler.class);
        BUILT_IN.put("xperfasm", WinPerfAsmProfiler.class);
        BUILT_IN.put("dtraceasm", DTraceAsmProfiler.class);
        BUILT_IN.put("pauses", PausesProfiler.class);
        BUILT_IN.put("safepoints", SafepointsProfiler.class);
        BUILT_IN.put("perfc2c", LinuxPerfC2CProfiler.class);
    }
}

