/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;

public class NBitInteger {
    public static int octectsNeeded(int n, int i2) {
        if (n == 8) {
            int nbits = 255;
            if ((i2 -= nbits) < 0) {
                return 1;
            }
            if (i2 == 0) {
                return 2;
            }
            int lz = Integer.numberOfLeadingZeros(i2);
            int log = 32 - lz;
            return 1 + (log + 6) / 7;
        }
        int nbits = 255 >>> 8 - n;
        if ((i2 -= nbits) < 0) {
            return 0;
        }
        if (i2 == 0) {
            return 1;
        }
        int lz = Integer.numberOfLeadingZeros(i2);
        int log = 32 - lz;
        return (log + 6) / 7;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void encode(ByteBuffer buf, int n, int i2) {
        int bits;
        int p;
        if (n != 8) {
            p = buf.position() - 1;
            bits = 255 >>> 8 - n;
            if (i2 < bits) {
                buf.put(p, (byte)(buf.get(p) & ~bits | i2));
                return;
            }
        } else {
            if (i2 < 255) {
                buf.put((byte)i2);
                return;
            }
            buf.put((byte)-1);
            int length = i2 - 255;
            while (true) {
                if ((length & 0xFFFFFF80) == 0) {
                    buf.put((byte)length);
                    return;
                }
                buf.put((byte)(length & 0x7F | 0x80));
                length >>>= 7;
            }
        }
        buf.put(p, (byte)(buf.get(p) | bits));
        int length = i2 - bits;
        while (true) {
            if ((length & 0xFFFFFF80) == 0) {
                buf.put((byte)length);
                return;
            }
            buf.put((byte)(length & 0x7F | 0x80));
            length >>>= 7;
        }
    }

    public static int decode(ByteBuffer buffer, int n) {
        if (n == 8) {
            int nbits = 255;
            int i2 = buffer.get() & 0xFF;
            if (i2 == nbits) {
                int b;
                int m3 = 1;
                do {
                    b = 0xFF & buffer.get();
                    i2 += (b & 0x7F) * m3;
                    m3 *= 128;
                } while ((b & 0x80) == 128);
            }
            return i2;
        }
        int nbits = 255 >>> 8 - n;
        int i3 = buffer.get(buffer.position() - 1) & nbits;
        if (i3 == nbits) {
            int b;
            int m4 = 1;
            do {
                b = 0xFF & buffer.get();
                i3 += (b & 0x7F) * m4;
                m4 *= 128;
            } while ((b & 0x80) == 128);
        }
        return i3;
    }
}

