/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.NonNull;

public class TcpResources
implements ConnectionProvider,
LoopResources {
    final ConnectionProvider defaultProvider;
    final LoopResources defaultLoops;
    static final Logger log = Loggers.getLogger(TcpResources.class);
    static final AtomicReference<TcpResources> tcpResources;
    static final BiFunction<LoopResources, ConnectionProvider, TcpResources> ON_TCP_NEW;

    public static TcpResources get() {
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(ConnectionProvider provider) {
        return TcpResources.getOrCreate(tcpResources, null, provider, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(LoopResources loops) {
        return TcpResources.getOrCreate(tcpResources, loops, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources reset() {
        TcpResources.disposeLoopsAndConnections();
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static void disposeLoopsAndConnections() {
        TcpResources resources2 = tcpResources.getAndSet(null);
        if (resources2 != null) {
            resources2._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return TcpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        return Mono.defer(() -> {
            TcpResources resources2 = tcpResources.getAndSet(null);
            if (resources2 != null) {
                return resources2._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    protected TcpResources(LoopResources defaultLoops, ConnectionProvider defaultProvider) {
        this.defaultLoops = defaultLoops;
        this.defaultProvider = defaultProvider;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    protected void _dispose() {
        this.defaultProvider.dispose();
        this.defaultLoops.dispose();
    }

    @Deprecated
    protected Mono<Void> _disposeLater() {
        return this.disposeLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.when(this.defaultLoops.disposeLater(quietPeriod, timeout), this.defaultProvider.disposeLater());
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed() && this.defaultProvider.isDisposed();
    }

    @Override
    public void disposeWhen(@NonNull SocketAddress address) {
        this.defaultProvider.disposeWhen(address);
    }

    @Override
    public Mono<? extends Connection> acquire(Bootstrap bootstrap) {
        return this.defaultProvider.acquire(bootstrap);
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.defaultLoops.onChannel(group);
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        return this.defaultLoops.onChannel(channelType, group);
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        return this.defaultLoops.onChannelClass(channelType, group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.defaultLoops.onDatagramChannel(group);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.defaultLoops.onServerChannel(group);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    @Override
    public boolean preferNative() {
        return this.defaultLoops.preferNative();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    protected static <T extends TcpResources> T getOrCreate(AtomicReference<T> ref, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, BiFunction<LoopResources, ConnectionProvider, T> onNew, String name) {
        TcpResources resources2;
        while ((resources2 = (TcpResources)ref.get()) == null || loops != null || provider != null) {
            TcpResources update = TcpResources.create(resources2, loops, provider, name, onNew);
            if (ref.compareAndSet(resources2, update)) {
                if (resources2 != null) {
                    if (loops != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new LoopResources: {}, the previous LoopResources will be disposed", name, loops);
                        }
                        resources2.defaultLoops.dispose();
                    }
                    if (provider != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new ConnectionProvider: {}, the previous ConnectionProvider will be disposed", name, provider);
                        }
                        resources2.defaultProvider.dispose();
                    }
                } else {
                    String poolType;
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", name, loopType, update.defaultLoops);
                    }
                    String string2 = poolType = provider == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} ConnectionProvider: {}", name, poolType, update.defaultProvider);
                    }
                }
                return (T)update;
            }
            update._dispose();
        }
        return (T)resources2;
    }

    static <T extends TcpResources> T create(@Nullable T previous, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, String name, BiFunction<LoopResources, ConnectionProvider, T> onNew) {
        if (previous == null) {
            loops = loops == null ? LoopResources.create("reactor-" + name) : loops;
            provider = provider == null ? ((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder(name).maxConnections(500)).pendingAcquireMaxCount(-1)).build() : provider;
        } else {
            loops = loops == null ? previous.defaultLoops : loops;
            provider = provider == null ? previous.defaultProvider : provider;
        }
        return (T)((TcpResources)onNew.apply(loops, provider));
    }

    static {
        ON_TCP_NEW = TcpResources::new;
        tcpResources = new AtomicReference();
    }
}

