/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.bootstrap.Bootstrap;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionPoolMetrics;
import reactor.netty.resources.NewConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.util.Metrics;
import reactor.util.annotation.NonNull;

@FunctionalInterface
public interface ConnectionProvider
extends Disposable {
    public static final int DEFAULT_POOL_MAX_CONNECTIONS = Integer.parseInt(System.getProperty("reactor.netty.pool.maxConnections", "" + Math.max(Runtime.getRuntime().availableProcessors(), 8) * 2));
    public static final long DEFAULT_POOL_ACQUIRE_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.pool.acquireTimeout", "45000"));
    public static final long DEFAULT_POOL_MAX_IDLE_TIME = Long.parseLong(System.getProperty("reactor.netty.pool.maxIdleTime", "-1"));
    public static final long DEFAULT_POOL_MAX_LIFE_TIME = Long.parseLong(System.getProperty("reactor.netty.pool.maxLifeTime", "-1"));
    public static final String LEASING_STRATEGY_FIFO = "fifo";
    public static final String LEASING_STRATEGY_LIFO = "lifo";
    public static final String DEFAULT_POOL_LEASING_STRATEGY = System.getProperty("reactor.netty.pool.leasingStrategy", "fifo").toLowerCase(Locale.ENGLISH);

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ConnectionProvider newConnection() {
        return NewConnectionProvider.INSTANCE;
    }

    public static ConnectionProvider create(String name) {
        return ((Builder)((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(DEFAULT_POOL_MAX_CONNECTIONS)).pendingAcquireMaxCount(500)).pendingAcquireTimeout(Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT))).build();
    }

    public static ConnectionProvider create(String name, int maxConnections) {
        return ((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(maxConnections)).pendingAcquireTimeout(Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT))).build();
    }

    @Deprecated
    public static ConnectionProvider elastic(String name) {
        return ConnectionProvider.elastic(name, null, null);
    }

    @Deprecated
    public static ConnectionProvider elastic(String name, @Nullable Duration maxIdleTime) {
        return ConnectionProvider.elastic(name, maxIdleTime, null);
    }

    @Deprecated
    public static ConnectionProvider elastic(String name, @Nullable Duration maxIdleTime, @Nullable Duration maxLifeTime) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(Integer.MAX_VALUE)).pendingAcquireTimeout(Duration.ofMillis(0L))).pendingAcquireMaxCount(-1)).maxIdleTime(maxIdleTime)).maxLifeTime(maxLifeTime)).build();
    }

    @Deprecated
    public static ConnectionProvider fixed(String name) {
        return ConnectionProvider.fixed(name, DEFAULT_POOL_MAX_CONNECTIONS);
    }

    @Deprecated
    public static ConnectionProvider fixed(String name, int maxConnections) {
        return ConnectionProvider.fixed(name, maxConnections, DEFAULT_POOL_ACQUIRE_TIMEOUT);
    }

    @Deprecated
    public static ConnectionProvider fixed(String name, int maxConnections, long acquireTimeout) {
        return ConnectionProvider.fixed(name, maxConnections, acquireTimeout, null, null);
    }

    @Deprecated
    public static ConnectionProvider fixed(String name, int maxConnections, long acquireTimeout, @Nullable Duration maxIdleTime) {
        return ConnectionProvider.fixed(name, maxConnections, acquireTimeout, maxIdleTime, null);
    }

    @Deprecated
    public static ConnectionProvider fixed(String name, int maxConnections, long acquireTimeout, @Nullable Duration maxIdleTime, @Nullable Duration maxLifeTime) {
        if (maxConnections == -1) {
            return ConnectionProvider.elastic(name, maxIdleTime, maxLifeTime);
        }
        if (acquireTimeout < 0L) {
            throw new IllegalArgumentException("Acquire Timeout value must be positive");
        }
        return ((Builder)((Builder)((Builder)((Builder)((Builder)ConnectionProvider.builder(name).maxConnections(maxConnections)).pendingAcquireMaxCount(-1)).pendingAcquireTimeout(Duration.ofMillis(acquireTimeout))).maxIdleTime(maxIdleTime)).maxLifeTime(maxLifeTime)).build();
    }

    public Mono<? extends Connection> acquire(Bootstrap var1);

    default public void disposeWhen(@NonNull SocketAddress address) {
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    default public int maxConnections() {
        return -1;
    }

    public static interface MeterRegistrar {
        public void registerMetrics(String var1, String var2, SocketAddress var3, ConnectionPoolMetrics var4);
    }

    public static final class HostSpecificSpec
    extends ConnectionPoolSpec<HostSpecificSpec> {
    }

    public static class ConnectionPoolSpec<SPEC extends ConnectionPoolSpec<SPEC>>
    implements Supplier<SPEC> {
        static final Duration EVICT_IN_BACKGROUND_DISABLED = Duration.ZERO;
        static final int PENDING_ACQUIRE_MAX_COUNT_NOT_SPECIFIED = -2;
        Duration evictionInterval = EVICT_IN_BACKGROUND_DISABLED;
        int maxConnections = DEFAULT_POOL_MAX_CONNECTIONS;
        int pendingAcquireMaxCount = -2;
        Duration pendingAcquireTimeout = Duration.ofMillis(DEFAULT_POOL_ACQUIRE_TIMEOUT);
        Duration maxIdleTime;
        Duration maxLifeTime;
        boolean metricsEnabled;
        String leasingStrategy = DEFAULT_POOL_LEASING_STRATEGY;
        Supplier<? extends MeterRegistrar> registrar;

        private ConnectionPoolSpec() {
            if (DEFAULT_POOL_MAX_IDLE_TIME > -1L) {
                this.maxIdleTime(Duration.ofMillis(DEFAULT_POOL_MAX_IDLE_TIME));
            }
            if (DEFAULT_POOL_MAX_LIFE_TIME > -1L) {
                this.maxLifeTime(Duration.ofMillis(DEFAULT_POOL_MAX_LIFE_TIME));
            }
        }

        public final SPEC pendingAcquireTimeout(Duration pendingAcquireTimeout) {
            this.pendingAcquireTimeout = Objects.requireNonNull(pendingAcquireTimeout, "pendingAcquireTimeout");
            return (SPEC)this.get();
        }

        public final SPEC maxConnections(int maxConnections) {
            if (maxConnections <= 0) {
                throw new IllegalArgumentException("Max Connections value must be strictly positive");
            }
            this.maxConnections = maxConnections;
            return (SPEC)this.get();
        }

        public final SPEC pendingAcquireMaxCount(int pendingAcquireMaxCount) {
            if (pendingAcquireMaxCount != -1 && pendingAcquireMaxCount <= 0) {
                throw new IllegalArgumentException("Pending acquire max count must be strictly positive");
            }
            this.pendingAcquireMaxCount = pendingAcquireMaxCount;
            return (SPEC)this.get();
        }

        public final SPEC maxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return (SPEC)this.get();
        }

        public final SPEC maxLifeTime(Duration maxLifeTime) {
            this.maxLifeTime = maxLifeTime;
            return (SPEC)this.get();
        }

        public final SPEC metrics(boolean metricsEnabled) {
            if (metricsEnabled && !Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            this.metricsEnabled = metricsEnabled;
            return (SPEC)this.get();
        }

        public final SPEC metrics(boolean metricsEnabled, Supplier<? extends MeterRegistrar> registrar) {
            this.metricsEnabled = metricsEnabled;
            this.registrar = Objects.requireNonNull(registrar);
            return (SPEC)this.get();
        }

        public final SPEC lifo() {
            this.leasingStrategy = ConnectionProvider.LEASING_STRATEGY_LIFO;
            return (SPEC)this.get();
        }

        public final SPEC fifo() {
            this.leasingStrategy = ConnectionProvider.LEASING_STRATEGY_FIFO;
            return (SPEC)this.get();
        }

        public final SPEC evictInBackground(Duration evictionInterval) {
            this.evictionInterval = Objects.requireNonNull(evictionInterval, "evictionInterval");
            return (SPEC)this.get();
        }

        @Override
        public SPEC get() {
            return (SPEC)this;
        }
    }

    public static final class Builder
    extends ConnectionPoolSpec<Builder> {
        String name;
        final Map<SocketAddress, ConnectionPoolSpec<?>> confPerRemoteHost = new HashMap();

        private Builder(String name) {
            this.name(name);
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder forRemoteHost(SocketAddress remoteHost, Consumer<HostSpecificSpec> spec) {
            Objects.requireNonNull(remoteHost, "remoteHost");
            Objects.requireNonNull(spec, "spec");
            HostSpecificSpec builder = new HostSpecificSpec();
            spec.accept(builder);
            this.confPerRemoteHost.put(remoteHost, builder);
            return this;
        }

        public ConnectionProvider build() {
            return new PooledConnectionProvider(this);
        }
    }
}

