/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.benchmarks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import reactivefeign.benchmarks.RealRequestBenchmarks;
import reactor.core.publisher.Mono;

@Measurement(iterations=5, time=1)
@Warmup(iterations=3, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class ParallelEmptyRequestBenchmarks
extends RealRequestBenchmarks {
    public static final int CALLS_NUMBER = 100;
    private ExecutorService executor;

    @Override
    @Setup
    public void setup() throws Exception {
        super.setup();
        this.executor = Executors.newFixedThreadPool(100);
    }

    @Override
    @TearDown
    public void tearDown() throws Exception {
        super.tearDown();
        this.executor.shutdown();
    }

    @Benchmark
    public void feignEmptyPayload() throws ExecutionException, InterruptedException {
        CompletableFuture[] bonusesCompletableFutures = (CompletableFuture[])IntStream.range(0, 100).mapToObj(runnable -> CompletableFuture.runAsync(() -> this.feign.justGet(), this.executor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(bonusesCompletableFutures).get();
    }

    @Benchmark
    public void webClient() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i2 -> this.webClientFeign.justGet()).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void jetty() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i2 -> this.jettyFeign.justGet()).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void jettyH2c() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i2 -> this.jettyFeignH2c.justGet()).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void java11() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i2 -> this.java11Feign.justGet()).collect(Collectors.toList()), values -> values).block();
    }

    @Benchmark
    public void java11H2c() {
        Mono.zip(IntStream.range(0, 100).mapToObj(i2 -> this.java11FeignH2c.justGet()).collect(Collectors.toList()), values -> values).block();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().jvmArgs("-Xms1024m", "-Xmx4024m").include(".*" + ParallelEmptyRequestBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

