/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Body;
import feign.DeclarativeContract;
import feign.Feign;
import feign.HeaderMap;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMap;
import feign.Request;
import feign.RequestLine;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Contract {
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> var1);

    public static class Default
    extends DeclarativeContract {
        static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("^([A-Z]+)[ ]*(.*)$");

        public Default() {
            super.registerClassAnnotation(Headers.class, (E header, MethodMetadata data) -> {
                String[] headersOnType = header.value();
                Util.checkState(headersOnType.length > 0, "Headers annotation was empty on type %s.", data.configKey());
                Map<String, Collection<String>> headers2 = Default.toMap(headersOnType);
                headers2.putAll(data.template().headers());
                data.template().headers(null);
                data.template().headers(headers2);
            });
            super.registerMethodAnnotation(RequestLine.class, (E ann, MethodMetadata data) -> {
                String requestLine = ann.value();
                Util.checkState(Util.emptyToNull(requestLine) != null, "RequestLine annotation was empty on method %s.", data.configKey());
                Matcher requestLineMatcher = REQUEST_LINE_PATTERN.matcher(requestLine);
                if (!requestLineMatcher.find()) {
                    throw new IllegalStateException(String.format("RequestLine annotation didn't start with an HTTP verb on method %s", data.configKey()));
                }
                data.template().method(Request.HttpMethod.valueOf(requestLineMatcher.group(1)));
                data.template().uri(requestLineMatcher.group(2));
                data.template().decodeSlash(ann.decodeSlash());
                data.template().collectionFormat(ann.collectionFormat());
            });
            super.registerMethodAnnotation(Body.class, (E ann, MethodMetadata data) -> {
                String body2 = ann.value();
                Util.checkState(Util.emptyToNull(body2) != null, "Body annotation was empty on method %s.", data.configKey());
                if (body2.indexOf(123) == -1) {
                    data.template().body(body2);
                } else {
                    data.template().bodyTemplate(body2);
                }
            });
            super.registerMethodAnnotation(Headers.class, (E header, MethodMetadata data) -> {
                String[] headersOnMethod = header.value();
                Util.checkState(headersOnMethod.length > 0, "Headers annotation was empty on method %s.", data.configKey());
                data.template().headers(Default.toMap(headersOnMethod));
            });
            super.registerParameterAnnotation(Param.class, (paramAnnotation, data, paramIndex) -> {
                String name = paramAnnotation.value();
                Util.checkState(Util.emptyToNull(name) != null, "Param annotation was empty on param %s.", paramIndex);
                this.nameParam(data, name, paramIndex);
                Class<? extends Param.Expander> expander = paramAnnotation.expander();
                if (expander != Param.ToStringExpander.class) {
                    data.indexToExpanderClass().put(paramIndex, expander);
                }
                if (!data.template().hasRequestVariable(name)) {
                    data.formParams().add(name);
                }
            });
            super.registerParameterAnnotation(QueryMap.class, (queryMap, data, paramIndex) -> {
                Util.checkState(data.queryMapIndex() == null, "QueryMap annotation was present on multiple parameters.", new Object[0]);
                data.queryMapIndex(paramIndex);
                data.queryMapEncoded(queryMap.encoded());
            });
            super.registerParameterAnnotation(HeaderMap.class, (queryMap, data, paramIndex) -> {
                Util.checkState(data.headerMapIndex() == null, "HeaderMap annotation was present on multiple parameters.", new Object[0]);
                data.headerMapIndex(paramIndex);
            });
        }

        private static Map<String, Collection<String>> toMap(String[] input) {
            LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>(input.length);
            for (String header : input) {
                int colon = header.indexOf(58);
                String name = header.substring(0, colon);
                if (!result.containsKey(name)) {
                    result.put(name, new ArrayList(1));
                }
                ((Collection)result.get(name)).add(header.substring(colon + 1).trim());
            }
            return result;
        }
    }

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
            Util.checkState(targetType.getTypeParameters().length == 0, "Parameterized types unsupported: %s", targetType.getSimpleName());
            Util.checkState(targetType.getInterfaces().length <= 1, "Only single inheritance supported: %s", targetType.getSimpleName());
            if (targetType.getInterfaces().length == 1) {
                Util.checkState(targetType.getInterfaces()[0].getInterfaces().length == 0, "Only single-level inheritance supported: %s", targetType.getSimpleName());
            }
            LinkedHashMap<String, MethodMetadata> result = new LinkedHashMap<String, MethodMetadata>();
            for (Method method2 : targetType.getMethods()) {
                if (method2.getDeclaringClass() == Object.class || (method2.getModifiers() & 8) != 0 || Util.isDefault(method2)) continue;
                MethodMetadata metadata = this.parseAndValidateMetadata(targetType, method2);
                Util.checkState(!result.containsKey(metadata.configKey()), "Overrides unsupported: %s", metadata.configKey());
                result.put(metadata.configKey(), metadata);
            }
            return new ArrayList<MethodMetadata>(result.values());
        }

        @Deprecated
        public MethodMetadata parseAndValidateMetadata(Method method2) {
            return this.parseAndValidateMetadata(method2.getDeclaringClass(), method2);
        }

        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method2) {
            MethodMetadata data = new MethodMetadata();
            data.targetType(targetType);
            data.method(method2);
            data.returnType(Types.resolve(targetType, targetType, method2.getGenericReturnType()));
            data.configKey(Feign.configKey(targetType, method2));
            if (targetType.getInterfaces().length == 1) {
                this.processAnnotationOnClass(data, targetType.getInterfaces()[0]);
            }
            this.processAnnotationOnClass(data, targetType);
            for (Annotation methodAnnotation : method2.getAnnotations()) {
                this.processAnnotationOnMethod(data, methodAnnotation, method2);
            }
            if (data.isIgnored()) {
                return data;
            }
            Util.checkState(data.template().method() != null, "Method %s not annotated with HTTP method type (ex. GET, POST)%s", data.configKey(), data.warnings());
            Class<?>[] parameterTypes = method2.getParameterTypes();
            Type[] genericParameterTypes = method2.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = method2.getParameterAnnotations();
            int count = parameterAnnotations.length;
            for (int i2 = 0; i2 < count; ++i2) {
                boolean isHttpAnnotation = false;
                if (parameterAnnotations[i2] != null) {
                    isHttpAnnotation = this.processAnnotationsOnParameter(data, parameterAnnotations[i2], i2);
                }
                if (isHttpAnnotation) {
                    data.ignoreParamater(i2);
                }
                if (parameterTypes[i2] == URI.class) {
                    data.urlIndex(i2);
                    continue;
                }
                if (isHttpAnnotation || parameterTypes[i2] == Request.Options.class) continue;
                if (data.isAlreadyProcessed(i2)) {
                    Util.checkState(data.formParams().isEmpty() || data.bodyIndex() == null, "Body parameters cannot be used with form parameters.%s", data.warnings());
                    continue;
                }
                Util.checkState(data.formParams().isEmpty(), "Body parameters cannot be used with form parameters.%s", data.warnings());
                Util.checkState(data.bodyIndex() == null, "Method has too many Body parameters: %s%s", method2, data.warnings());
                data.bodyIndex(i2);
                data.bodyType(Types.resolve(targetType, targetType, genericParameterTypes[i2]));
            }
            if (data.headerMapIndex() != null) {
                BaseContract.checkMapString("HeaderMap", parameterTypes[data.headerMapIndex()], genericParameterTypes[data.headerMapIndex()]);
            }
            if (data.queryMapIndex() != null && Map.class.isAssignableFrom(parameterTypes[data.queryMapIndex()])) {
                BaseContract.checkMapKeys("QueryMap", genericParameterTypes[data.queryMapIndex()]);
            }
            return data;
        }

        private static void checkMapString(String name, Class<?> type, Type genericType) {
            Util.checkState(Map.class.isAssignableFrom(type), "%s parameter must be a Map: %s", name, type);
            BaseContract.checkMapKeys(name, genericType);
        }

        private static void checkMapKeys(String name, Type genericType) {
            Type[] interfaces;
            Class keyClass = null;
            if (ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
                Type[] parameterTypes = ((ParameterizedType)genericType).getActualTypeArguments();
                keyClass = (Class)parameterTypes[0];
            } else if (genericType instanceof Class && (interfaces = ((Class)genericType).getGenericInterfaces()) != null) {
                for (Type extended : interfaces) {
                    if (!ParameterizedType.class.isAssignableFrom(extended.getClass())) continue;
                    Type[] parameterTypes = ((ParameterizedType)extended).getActualTypeArguments();
                    keyClass = (Class)parameterTypes[0];
                    break;
                }
            }
            if (keyClass != null) {
                Util.checkState(String.class.equals(keyClass), "%s key must be a String: %s", name, keyClass.getSimpleName());
            }
        }

        protected abstract void processAnnotationOnClass(MethodMetadata var1, Class<?> var2);

        protected abstract void processAnnotationOnMethod(MethodMetadata var1, Annotation var2, Method var3);

        protected abstract boolean processAnnotationsOnParameter(MethodMetadata var1, Annotation[] var2, int var3);

        protected void nameParam(MethodMetadata data, String name, int i2) {
            ArrayList<String> names = data.indexToName().containsKey(i2) ? data.indexToName().get(i2) : new ArrayList<String>();
            names.add(name);
            data.indexToName().put(i2, names);
        }
    }
}

