/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.multipart.FileItemPartAdapter;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.UploadContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class PartParser {
    public static Collection<Request.Part> parseFrom(Request request) {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory(Integer.MAX_VALUE, new File(System.getProperty("java.io.tmpdir")));
        HttpHeaders headers2 = request.getHeaders();
        ByteArrayUploadContext uploadContext = new ByteArrayUploadContext(request.getBody(), PartParser.headerValueOrNull("Content-Encoding", headers2), headers2.getContentTypeHeader().firstValue());
        FileUpload upload = new FileUpload(fileItemFactory);
        try {
            List<FileItem> items = upload.parseRequest(uploadContext);
            return Lists.transform(items, FileItemPartAdapter.TO_PARTS);
        }
        catch (FileUploadException e) {
            return Exceptions.throwUnchecked(e, Collection.class);
        }
    }

    private static String headerValueOrNull(String key, HttpHeaders httpHeaders) {
        HttpHeader header = httpHeaders.getHeader(key);
        return header.isPresent() ? header.firstValue() : null;
    }

    public static class ByteArrayUploadContext
    implements UploadContext {
        private final byte[] content;
        private final String encoding;
        private final String contentType;

        public ByteArrayUploadContext(byte[] content, String encoding, String contentType2) {
            this.content = content;
            this.encoding = encoding;
            this.contentType = contentType2;
        }

        @Override
        public long contentLength() {
            return this.content.length;
        }

        @Override
        public String getCharacterEncoding() {
            return this.encoding;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getContentLength() {
            return this.content.length;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }
    }
}

