/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.internal.shaded.reactor.pool.AllocationStrategies;
import reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;
import reactor.netty.internal.shaded.reactor.pool.DefaultPoolConfig;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.NoOpPoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.Pool;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.netty.internal.shaded.reactor.pool.SimpleFifoPool;
import reactor.netty.internal.shaded.reactor.pool.SimpleLifoPool;

public class PoolBuilder<T, CONF extends PoolConfig<T>> {
    final Mono<T> allocator;
    final Function<PoolConfig<T>, CONF> configModifier;
    int maxPending = -1;
    AllocationStrategy allocationStrategy = null;
    Function<T, ? extends Publisher<Void>> releaseHandler = PoolBuilder.noopHandler();
    Function<T, ? extends Publisher<Void>> destroyHandler = PoolBuilder.noopHandler();
    BiPredicate<T, PooledRefMetadata> evictionPredicate = PoolBuilder.neverPredicate();
    Scheduler acquisitionScheduler = Schedulers.immediate();
    Clock clock = Clock.systemUTC();
    PoolMetricsRecorder metricsRecorder = NoOpPoolMetricsRecorder.INSTANCE;
    static final Function<?, Mono<Void>> NOOP_HANDLER = it -> Mono.empty();
    static final BiPredicate<?, ?> NEVER_PREDICATE = (ignored1, ignored2) -> false;

    public static <T> PoolBuilder<T, PoolConfig<T>> from(Publisher<? extends T> allocator) {
        Mono<? extends T> source = Mono.from(allocator);
        return new PoolBuilder(source, Function.identity());
    }

    PoolBuilder(Mono<T> allocator, Function<PoolConfig<T>, CONF> configModifier) {
        this.allocator = allocator;
        this.configModifier = configModifier;
    }

    PoolBuilder(PoolBuilder<T, ?> source, Function<PoolConfig<T>, CONF> configModifier) {
        this.configModifier = configModifier;
        this.allocator = source.allocator;
        this.maxPending = source.maxPending;
        this.allocationStrategy = source.allocationStrategy;
        this.releaseHandler = source.releaseHandler;
        this.destroyHandler = source.destroyHandler;
        this.evictionPredicate = source.evictionPredicate;
        this.acquisitionScheduler = source.acquisitionScheduler;
        this.metricsRecorder = source.metricsRecorder;
        this.clock = source.clock;
    }

    public PoolBuilder<T, CONF> acquisitionScheduler(Scheduler acquisitionScheduler) {
        this.acquisitionScheduler = Objects.requireNonNull(acquisitionScheduler, "acquisitionScheduler");
        return this;
    }

    public PoolBuilder<T, CONF> allocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = Objects.requireNonNull(allocationStrategy, "allocationStrategy");
        return this;
    }

    public PoolBuilder<T, CONF> destroyHandler(Function<T, ? extends Publisher<Void>> destroyHandler) {
        this.destroyHandler = Objects.requireNonNull(destroyHandler, "destroyHandler");
        return this;
    }

    public PoolBuilder<T, CONF> evictionIdle(Duration maxIdleTime) {
        return this.evictionPredicate(PoolBuilder.idlePredicate(maxIdleTime));
    }

    public PoolBuilder<T, CONF> evictionPredicate(BiPredicate<T, PooledRefMetadata> evictionPredicate) {
        this.evictionPredicate = Objects.requireNonNull(evictionPredicate, "evictionPredicate");
        return this;
    }

    public PoolBuilder<T, CONF> maxPendingAcquire(int maxPending) {
        this.maxPending = maxPending;
        return this;
    }

    public PoolBuilder<T, CONF> maxPendingAcquireUnbounded() {
        this.maxPending = -1;
        return this;
    }

    public PoolBuilder<T, CONF> clock(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        return this;
    }

    public PoolBuilder<T, CONF> metricsRecorder(PoolMetricsRecorder recorder) {
        this.metricsRecorder = Objects.requireNonNull(recorder, "recorder");
        return this;
    }

    public PoolBuilder<T, CONF> releaseHandler(Function<T, ? extends Publisher<Void>> releaseHandler) {
        this.releaseHandler = Objects.requireNonNull(releaseHandler, "releaseHandler");
        return this;
    }

    public PoolBuilder<T, CONF> sizeBetween(int min2, int max) {
        return this.allocationStrategy(new AllocationStrategies.SizeBasedAllocationStrategy(min2, max));
    }

    public PoolBuilder<T, CONF> sizeUnbounded() {
        return this.allocationStrategy(new AllocationStrategies.UnboundedAllocationStrategy());
    }

    public <CONF2 extends PoolConfig<T>> PoolBuilder<T, CONF2> extraConfiguration(Function<? super CONF, CONF2> configModifier) {
        return new PoolBuilder<T, CONF2>(this, this.configModifier.andThen(configModifier));
    }

    public InstrumentedPool<T> lifo() {
        return this.build(SimpleLifoPool::new);
    }

    public InstrumentedPool<T> fifo() {
        return this.build(SimpleFifoPool::new);
    }

    public <POOL extends Pool<T>> POOL build(Function<? super CONF, POOL> poolFactory) {
        CONF config = this.buildConfig();
        return (POOL)((Pool)poolFactory.apply(config));
    }

    CONF buildConfig() {
        DefaultPoolConfig<T> baseConfig = new DefaultPoolConfig<T>(this.allocator, this.allocationStrategy == null ? new AllocationStrategies.UnboundedAllocationStrategy() : this.allocationStrategy, this.maxPending, this.releaseHandler, this.destroyHandler, this.evictionPredicate, this.acquisitionScheduler, this.metricsRecorder, this.clock);
        return (CONF)((PoolConfig)this.configModifier.apply(baseConfig));
    }

    static <T> Function<T, Mono<Void>> noopHandler() {
        return NOOP_HANDLER;
    }

    static <T> BiPredicate<T, PooledRefMetadata> neverPredicate() {
        return NEVER_PREDICATE;
    }

    static <T> BiPredicate<T, PooledRefMetadata> idlePredicate(Duration maxIdleTime) {
        return (poolable, meta) -> meta.idleTime() >= maxIdleTime.toMillis();
    }
}

