/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Comparator;
import java.util.List;

public class NearMissCalculator {
    public static final int NEAR_MISS_COUNT = 3;
    public static final Comparator<NearMiss> NEAR_MISS_ASCENDING_COMPARATOR = new Comparator<NearMiss>(){

        @Override
        public int compare(NearMiss o1, NearMiss o2) {
            return o1.compareTo(o2);
        }
    };
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final Scenarios scenarios;

    public NearMissCalculator(StubMappings stubMappings, RequestJournal requestJournal, Scenarios scenarios) {
        this.stubMappings = stubMappings;
        this.requestJournal = requestJournal;
        this.scenarios = scenarios;
    }

    public List<NearMiss> findNearestTo(final LoggedRequest request) {
        List<StubMapping> allMappings = this.stubMappings.getAll();
        return NearMissCalculator.sortAndTruncate(FluentIterable.from(allMappings).transform(new Function<StubMapping, NearMiss>(){

            @Override
            public NearMiss apply(StubMapping stubMapping) {
                MatchResult matchResult = stubMapping.getRequest().match(request);
                String actualScenarioState = NearMissCalculator.this.getScenarioStateOrNull(stubMapping);
                return new NearMiss(request, stubMapping, matchResult, actualScenarioState);
            }
        }), allMappings.size());
    }

    private String getScenarioStateOrNull(StubMapping stubMapping) {
        if (!stubMapping.isInScenario()) {
            return null;
        }
        Scenario scenario = this.scenarios.getByName(stubMapping.getScenarioName());
        return scenario != null ? scenario.getState() : null;
    }

    public List<NearMiss> findNearestTo(final RequestPattern requestPattern) {
        List<ServeEvent> serveEvents = this.requestJournal.getAllServeEvents();
        return NearMissCalculator.sortAndTruncate(FluentIterable.from(serveEvents).transform(new Function<ServeEvent, NearMiss>(){

            @Override
            public NearMiss apply(ServeEvent serveEvent) {
                MatchResult matchResult = requestPattern.match(serveEvent.getRequest());
                return new NearMiss(serveEvent.getRequest(), requestPattern, matchResult);
            }
        }), serveEvents.size());
    }

    private static List<NearMiss> sortAndTruncate(FluentIterable<NearMiss> nearMisses, int originalSize) {
        return nearMisses.toSortedList(NEAR_MISS_ASCENDING_COMPARATOR).subList(0, Math.min(3, originalSize));
    }
}

