/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.matching.JsonPathPatternJsonSerializer;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Map;

@JsonSerialize(using=JsonPathPatternJsonSerializer.class)
public class MatchesJsonPathPattern
extends PathPattern {
    public MatchesJsonPathPattern(@JsonProperty(value="matchesJsonPath") String expectedJsonPath, StringValuePattern valuePattern) {
        super(expectedJsonPath, valuePattern);
    }

    public MatchesJsonPathPattern(String value) {
        this(value, null);
    }

    public String getMatchesJsonPath() {
        return (String)this.expectedValue;
    }

    @Override
    protected MatchResult isSimpleMatch(String value) {
        if (value != null && value.trim().startsWith("<")) {
            LocalNotifier.notifier().info(String.format("Warning: JSON path expression '%s' failed to match document '%s' because it's not JSON document", this.expectedValue, value));
            return MatchResult.noMatch();
        }
        try {
            Object obj = JsonPath.read(value, (String)this.expectedValue, new Predicate[0]);
            boolean result = obj instanceof Collection ? !((Collection)obj).isEmpty() : (obj instanceof Map ? !((Map)obj).isEmpty() : obj != null);
            return MatchResult.of(result);
        }
        catch (Exception e) {
            String error = e.getMessage().equalsIgnoreCase("invalid path") ? "the JSON path didn't match the document structure" : (e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'");
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.expectedValue, value, error);
            LocalNotifier.notifier().info(message);
            return MatchResult.noMatch();
        }
    }

    @Override
    protected MatchResult isAdvancedMatch(String value) {
        try {
            String expressionResult = this.getExpressionResult(value);
            return this.valuePattern.match(expressionResult);
        }
        catch (PathPattern.SubExpressionException e) {
            LocalNotifier.notifier().info(e.getMessage());
            return MatchResult.noMatch();
        }
    }

    @Override
    public String getExpressionResult(String value) {
        if (value != null && value.trim().startsWith("<")) {
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because it's not JSON document", this.expectedValue, value);
            LocalNotifier.notifier().info(message);
            throw new PathPattern.SubExpressionException(message);
        }
        Object obj = null;
        try {
            obj = JsonPath.read(value, (String)this.expectedValue, new Predicate[0]);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (Exception e) {
            String error = e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'";
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.expectedValue, value, error);
            throw new PathPattern.SubExpressionException(message, e);
        }
        String expressionResult = obj instanceof Number || obj instanceof String || obj instanceof Boolean ? String.valueOf(obj) : (obj instanceof Map || obj instanceof Collection ? Json.write(obj) : null);
        return expressionResult;
    }
}

