/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty.utils;

import java.util.function.BiConsumer;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ProxyPostProcessor<I>
extends AbstractSingleProcessor<I, I> {
    private final Publisher<I> publisher;
    private final BiConsumer<I, Throwable> postProcessor;

    private ProxyPostProcessor(Publisher<I> publisher, BiConsumer<I, Throwable> postProcessor) {
        this.publisher = publisher;
        this.postProcessor = postProcessor;
    }

    @Override
    public void onNext(I i2) {
        try {
            this.downStreamOnNext(i2);
            this.postProcessor.accept(i2, null);
        }
        catch (Throwable err) {
            this.postProcessor.accept(i2, err);
        }
    }

    @Override
    public void subscribe(Subscriber<? super I> s) {
        this.publisher.subscribe(this);
        super.subscribe(s);
    }

    public static <I> Publisher<I> postProcess(Publisher<I> publisher, BiConsumer<I, Throwable> postProcessor) {
        return new ProxyPostProcessor<I>(publisher, postProcessor);
    }
}

