/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.statushandler;

import feign.Request;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.utils.FeignUtils;
import reactivefeign.utils.HttpStatus;
import reactivefeign.utils.HttpUtils;
import reactor.core.publisher.Mono;

public class ReactiveStatusHandlers {
    public static ReactiveStatusHandler defaultFeignErrorDecoder() {
        return ReactiveStatusHandlers.errorDecoder(new ErrorDecoder.Default());
    }

    public static ReactiveStatusHandler errorDecoder(final ErrorDecoder errorDecoder) {
        return new ReactiveStatusHandler(){

            @Override
            public boolean shouldHandle(int status) {
                return HttpUtils.familyOf(status).isError();
            }

            @Override
            public Mono<? extends Throwable> decode(String methodTag, ReactiveHttpResponse response) {
                return response.bodyData().defaultIfEmpty(new byte[0]).map(bodyData -> errorDecoder.decode(methodTag, ReactiveStatusHandlers.buildFeignResponseForDecoder(response, bodyData)));
            }
        };
    }

    private static Response buildFeignResponseForDecoder(ReactiveHttpResponse response, byte[] bodyData) {
        ReactiveHttpRequest request = response.request();
        Request feignRequest = Request.create(FeignUtils.httpMethod(request.method()), request.uri().toString(), request.headers(), Request.Body.empty(), null);
        return Response.builder().request(feignRequest).status(response.status()).reason(HttpStatus.getStatusText(response.status())).headers(response.headers()).body(bodyData).build();
    }

    public static ReactiveStatusHandler throwOnStatus(final Predicate<Integer> statusPredicate, final BiFunction<String, ReactiveHttpResponse, Throwable> errorFunction) {
        return new ReactiveStatusHandler(){

            @Override
            public boolean shouldHandle(int status) {
                return statusPredicate.test(status);
            }

            @Override
            public Mono<? extends Throwable> decode(String methodKey, ReactiveHttpResponse response) {
                return Mono.just((Throwable)errorFunction.apply(methodKey, response));
            }
        };
    }
}

