/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.http.GenericHttpUriRequest;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;

public class HttpClientFactory {
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final int DEFAULT_TIMEOUT = 30000;

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings) {
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setMaxConnTotal(maxConnections).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutMilliseconds).build()).useSystemProperties().setHostnameVerifier(new AllowAllHostnameVerifier());
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (!StringUtils.isEmpty(proxySettings.getUsername()) && !StringUtils.isEmpty(proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword()));
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            builder.setSslcontext(HttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings));
        } else {
            builder.setSslcontext(HttpClientFactory.buildAllowAnythingSSLContext());
        }
        return builder.build();
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            return SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray()).useTLS().build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE);
    }

    public static CloseableHttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static CloseableHttpClient createClient(ProxySettings proxySettings) {
        return HttpClientFactory.createClient(50, 30000, proxySettings, KeyStoreSettings.NO_STORE);
    }

    public static CloseableHttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }

    public static HttpUriRequest getHttpRequestFor(RequestMethod method2, String url) {
        LocalNotifier.notifier().info("Proxying: " + method2 + " " + url);
        if (method2.equals(RequestMethod.GET)) {
            return new HttpGet(url);
        }
        if (method2.equals(RequestMethod.POST)) {
            return new HttpPost(url);
        }
        if (method2.equals(RequestMethod.PUT)) {
            return new HttpPut(url);
        }
        if (method2.equals(RequestMethod.DELETE)) {
            return new HttpDelete(url);
        }
        if (method2.equals(RequestMethod.HEAD)) {
            return new HttpHead(url);
        }
        if (method2.equals(RequestMethod.OPTIONS)) {
            return new HttpOptions(url);
        }
        if (method2.equals(RequestMethod.TRACE)) {
            return new HttpTrace(url);
        }
        if (method2.equals(RequestMethod.PATCH)) {
            return new HttpPatch(url);
        }
        return new GenericHttpUriRequest(method2.toString(), url);
    }
}

