/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.DatagramChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.udp.UdpInbound;
import reactor.netty.udp.UdpOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    final DatagramChannel datagramChannel;
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    UdpOperations(Connection c, ConnectionObserver listener) {
        super(c, listener);
        this.datagramChannel = (DatagramChannel)c.channel();
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress));
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress));
    }
}

