/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.ssl.SslContextBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientOperator;

final class TcpClientSecure
extends TcpClientOperator {
    final SslProvider sslProvider;
    static final SslProvider DEFAULT_CLIENT_PROVIDER;

    static TcpClient secure(TcpClient client, Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.Build builder = (SslProvider.Build)SslProvider.builder();
        sslProviderBuilder.accept(builder);
        return new TcpClientSecure(client, builder.build());
    }

    TcpClientSecure(TcpClient client, @Nullable SslProvider provider) {
        super(client);
        this.sslProvider = provider == null ? DEFAULT_CLIENT_PROVIDER : Objects.requireNonNull(provider, "provider");
    }

    @Override
    public Bootstrap configure() {
        return SslProvider.setBootstrap(this.source.configure(), this.sslProvider);
    }

    @Override
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    static {
        SslProvider sslProvider;
        try {
            sslProvider = SslProvider.builder().sslContext(SslContextBuilder.forClient()).defaultConfiguration(SslProvider.DefaultConfigurationType.TCP).build();
        }
        catch (Exception e) {
            sslProvider = null;
        }
        DEFAULT_CLIENT_PROVIDER = sslProvider;
    }
}

