/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientOperator;

final class TcpClientDoOn
extends TcpClientOperator
implements ConnectionObserver {
    final Consumer<? super Bootstrap> onConnect;
    final Consumer<? super Connection> onConnected;
    final Consumer<? super Connection> onDisconnected;

    TcpClientDoOn(TcpClient client, @Nullable Consumer<? super Bootstrap> onConnect, @Nullable Consumer<? super Connection> onConnected, @Nullable Consumer<? super Connection> onDisconnected) {
        super(client);
        this.onConnect = onConnect;
        this.onConnected = onConnected;
        this.onDisconnected = onDisconnected;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(b);
        BootstrapHandlers.connectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public Mono<? extends Connection> connect(Bootstrap b) {
        if (this.onConnect != null) {
            return this.source.connect(b).doOnSubscribe(s -> this.onConnect.accept(b));
        }
        return this.source.connect(b);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (this.onConnected != null && newState == ConnectionObserver.State.CONFIGURED) {
            this.onConnected.accept(connection);
            return;
        }
        if (this.onDisconnected != null) {
            if (newState == ConnectionObserver.State.DISCONNECTING) {
                connection.onDispose(() -> this.onDisconnected.accept(connection));
            } else if (newState == ConnectionObserver.State.RELEASED) {
                this.onDisconnected.accept(connection);
            }
        }
    }
}

