/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import reactor.netty.http.server.AccessLog;

final class AccessLogHandlerH2
extends ChannelDuplexHandler {
    static final String H2_PROTOCOL_NAME = "HTTP/2.0";
    AccessLog accessLog = new AccessLog();

    AccessLogHandlerH2() {
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame requestHeaders = (Http2HeadersFrame)msg;
            SocketChannel channel = (SocketChannel)ctx.channel().parent();
            Http2Headers headers2 = requestHeaders.headers();
            this.accessLog = new AccessLog().address(channel.remoteAddress().getHostString()).port(channel.localAddress().getPort()).method(headers2.method()).uri(headers2.path()).protocol(H2_PROTOCOL_NAME);
        }
        super.channelRead(ctx, msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        boolean lastContent = false;
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame responseHeaders = (Http2HeadersFrame)msg;
            Http2Headers headers2 = responseHeaders.headers();
            lastContent = responseHeaders.isEndStream();
            this.accessLog.status(headers2.status()).chunked(true);
        }
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame data = (Http2DataFrame)msg;
            lastContent = data.isEndStream();
            this.accessLog.increaseContentLength(data.content().readableBytes());
        }
        if (lastContent) {
            ctx.write(msg, promise).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    this.accessLog.log();
                }
            }));
            return;
        }
        ctx.write(msg, promise);
    }
}

