/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.retry;

import java.time.Duration;
import java.util.function.Function;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public abstract class SimpleReactiveRetryPolicy
implements ReactiveRetryPolicy {
    public abstract long retryDelay(Throwable var1, int var2);

    @Override
    public Function<Flux<Throwable>, Flux<Throwable>> toRetryFunction() {
        return errors -> errors.zipWith(Flux.range(1, Integer.MAX_VALUE), (error, index) -> {
            long delay = this.retryDelay((Throwable)error, (int)index);
            if (delay >= 0L) {
                return Tuples.of(delay, error);
            }
            throw Exceptions.propagate(error);
        }).concatMap(tuple2 -> (Long)tuple2.getT1() > 0L ? Mono.delay(Duration.ofMillis((Long)tuple2.getT1())).map(time -> (Throwable)tuple2.getT2()) : Mono.just((Throwable)tuple2.getT2()));
    }
}

