/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.methodhandler;

import feign.MethodMetadata;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.MultiValueMapUtils;
import reactivefeign.utils.Pair;
import reactivefeign.utils.StringUtils;
import reactor.core.publisher.Mono;

public class PublisherClientMethodHandler
implements MethodHandler {
    public static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\{([^}]+)\\}");
    private final Target target;
    private final MethodMetadata methodMetadata;
    private final PublisherHttpClient publisherClient;
    private final Function<Map<String, ?>, String> pathExpander;
    private final Map<String, List<Function<Map<String, ?>, List<String>>>> headerExpanders;
    private final Map<String, Collection<String>> queriesAll;
    private final Map<String, List<Function<Map<String, ?>, List<String>>>> queryExpanders;
    private final URI staticUri;

    public PublisherClientMethodHandler(Target target, MethodMetadata methodMetadata, PublisherHttpClient publisherClient) {
        this.target = Util.checkNotNull(target, "target must be not null", new Object[0]);
        this.methodMetadata = Util.checkNotNull(methodMetadata, "methodMetadata must be not null", new Object[0]);
        this.publisherClient = Util.checkNotNull(publisherClient, "client must be not null", new Object[0]);
        RequestTemplate requestTemplate = methodMetadata.template();
        this.pathExpander = PublisherClientMethodHandler.buildUrlExpandFunction(target.url() + StringUtils.cutTail(requestTemplate.url(), requestTemplate.queryLine()));
        this.headerExpanders = PublisherClientMethodHandler.buildExpanders(requestTemplate.headers());
        this.queriesAll = new HashMap<String, Collection<String>>(requestTemplate.queries());
        methodMetadata.formParams().forEach(param -> MultiValueMapUtils.add(this.queriesAll, param, "{" + param + "}"));
        this.queryExpanders = PublisherClientMethodHandler.buildExpanders(this.queriesAll);
        this.staticUri = this.pathExpander instanceof StaticPathExpander && this.queriesAll.isEmpty() && methodMetadata.queryMapIndex() == null ? URI.create(target.url() + requestTemplate.url()) : null;
    }

    @Override
    public Publisher<?> invoke(Object[] argv) {
        ReactiveHttpRequest request = this.buildRequest(argv);
        return this.publisherClient.executeRequest(request);
    }

    protected ReactiveHttpRequest buildRequest(Object[] argv) {
        Map<String, Object> substitutionsMap = this.buildSubstitutions(argv);
        URI uri = this.buildUri(argv, substitutionsMap);
        Map<String, List<String>> headers2 = this.headers(argv, substitutionsMap);
        return new ReactiveHttpRequest(this.methodMetadata.template().method(), uri, headers2, this.body(argv));
    }

    private URI buildUri(Object[] argv, Map<String, ?> substitutionsMap) {
        if (this.staticUri != null) {
            return this.staticUri;
        }
        String path2 = this.pathExpander.apply(substitutionsMap);
        Map<String, Collection<String>> queries = this.queries(argv, substitutionsMap);
        String queryLine = this.queryLine(queries);
        return URI.create(path2 + queryLine);
    }

    private Map<String, Object> buildSubstitutions(Object[] argv) {
        return this.methodMetadata.indexToName().entrySet().stream().filter(e -> argv[(Integer)e.getKey()] != null).flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleImmutableEntry<Integer, String>((Integer)e.getKey(), (String)v))).collect(Collectors.toMap(Map.Entry::getValue, entry -> argv[(Integer)entry.getKey()]));
    }

    private String queryLine(Map<String, Collection<String>> queries) {
        if (queries.isEmpty()) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry<String, Collection<String>> query : queries.entrySet()) {
            String field = query.getKey();
            for (String value : query.getValue()) {
                queryBuilder.append('&');
                queryBuilder.append(field);
                queryBuilder.append('=');
                if (value.isEmpty()) continue;
                queryBuilder.append(value);
            }
        }
        if (queryBuilder.length() > 0) {
            queryBuilder.deleteCharAt(0);
            return queryBuilder.insert(0, '?').toString();
        }
        return "";
    }

    protected Map<String, Collection<String>> queries(Object[] argv, Map<String, ?> substitutionsMap) {
        LinkedHashMap<String, Collection<String>> queries = new LinkedHashMap<String, Collection<String>>();
        this.queriesAll.keySet().forEach(queryName -> MultiValueMapUtils.addAll(queries, queryName, this.queryExpanders.get(queryName).stream().map(expander -> (List)expander.apply(substitutionsMap)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList())));
        if (this.methodMetadata.queryMapIndex() != null && argv[this.methodMetadata.queryMapIndex()] != null) {
            ((Map)argv[this.methodMetadata.queryMapIndex()]).forEach((key, value) -> {
                if (value instanceof Iterable) {
                    ((Iterable)value).forEach(element -> MultiValueMapUtils.add(queries, key, element.toString()));
                } else if (value != null) {
                    MultiValueMapUtils.add(queries, key, value.toString());
                }
            });
        }
        return queries;
    }

    protected Map<String, List<String>> headers(Object[] argv, Map<String, ?> substitutionsMap) {
        LinkedHashMap<String, List<String>> headers2 = new LinkedHashMap<String, List<String>>();
        this.methodMetadata.template().headers().keySet().forEach(headerName -> MultiValueMapUtils.addAllOrdered(headers2, headerName, this.headerExpanders.get(headerName).stream().map(expander -> (List)expander.apply(substitutionsMap)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList())));
        if (this.methodMetadata.headerMapIndex() != null) {
            ((Map)argv[this.methodMetadata.headerMapIndex()]).forEach((key, value) -> {
                if (value instanceof Iterable) {
                    ((Iterable)value).forEach(element -> MultiValueMapUtils.addOrdered(headers2, key, element.toString()));
                } else {
                    MultiValueMapUtils.addOrdered(headers2, key, value.toString());
                }
            });
        }
        return headers2;
    }

    protected Publisher<Object> body(Object[] argv) {
        if (this.methodMetadata.bodyIndex() != null) {
            return this.body(argv[this.methodMetadata.bodyIndex()]);
        }
        return Mono.empty();
    }

    protected Publisher<Object> body(Object body2) {
        if (body2 instanceof Publisher) {
            return (Publisher)body2;
        }
        return Mono.just(body2);
    }

    private static Map<String, List<Function<Map<String, ?>, List<String>>>> buildExpanders(Map<String, Collection<String>> templates) {
        Stream templatesFlattened = templates.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new Pair<String, String>((String)e.getKey(), (String)v)));
        return templatesFlattened.collect(Collectors.groupingBy(entry -> (String)entry.left, Collectors.mapping(entry -> PublisherClientMethodHandler.buildExpandFunction((String)entry.right), Collectors.toList())));
    }

    private static Function<Map<String, ?>, List<String>> buildExpandFunction(String template) {
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(template);
        if (matcher.matches()) {
            String substitute = matcher.group(1);
            return traceData -> {
                Object substitution = traceData.get(substitute);
                if (substitution != null) {
                    if (substitution instanceof Iterable) {
                        ArrayList stringValues = new ArrayList();
                        ((Iterable)substitution).forEach(o -> stringValues.add(o.toString()));
                        return stringValues;
                    }
                    return Collections.singletonList(substitution.toString());
                }
                return null;
            };
        }
        return traceData -> Collections.singletonList(template);
    }

    private static Function<Map<String, ?>, String> buildUrlExpandFunction(String template) {
        String textChunk;
        ArrayList<Function<Map, String>> chunks = new ArrayList<Function<Map, String>>();
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(template);
        int previousMatchEnd = 0;
        while (matcher.find()) {
            textChunk = template.substring(previousMatchEnd, matcher.start());
            if (textChunk.length() > 0) {
                chunks.add(data -> textChunk);
            }
            String substitute = matcher.group(1);
            chunks.add(data -> {
                Object substitution = data.get(substitute);
                if (substitution != null) {
                    return substitution.toString();
                }
                throw new IllegalArgumentException("No substitution in url for:" + substitute);
            });
            previousMatchEnd = matcher.end();
        }
        if (previousMatchEnd == 0) {
            return new StaticPathExpander(template);
        }
        textChunk = template.substring(previousMatchEnd);
        if (textChunk.length() > 0) {
            chunks.add(data -> textChunk);
        }
        return traceData -> chunks.stream().map(chunk -> (String)chunk.apply(traceData)).collect(Collectors.joining());
    }

    private static class StaticPathExpander
    implements Function<Map<String, ?>, String> {
        private final String staticPath;

        private StaticPathExpander(String staticPath) {
            this.staticPath = staticPath;
        }

        @Override
        public String apply(Map<String, ?> stringMap) {
            return this.staticPath;
        }
    }
}

