/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.java11.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.MethodMetadata;
import feign.Target;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpClientFactory;
import reactivefeign.java11.Java11ReactiveOptions;
import reactivefeign.java11.client.Java11ReactiveHttpClient;

public class Java11ReactiveHttpClientFactory
implements ReactiveHttpClientFactory {
    private final HttpClient httpClient;
    private final JsonFactory jsonFactory;
    private final ObjectMapper objectMapper;
    private final Java11ReactiveOptions options;

    public Java11ReactiveHttpClientFactory(HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper, Java11ReactiveOptions options) {
        this.httpClient = httpClient;
        this.jsonFactory = jsonFactory;
        this.objectMapper = objectMapper;
        this.options = options;
        if (ReactiveOptions.useHttp2(options) && HttpClient.Version.HTTP_2 != httpClient.version()) {
            throw new IllegalArgumentException("Set correct version to httpClient");
        }
    }

    @Override
    public void target(Target target) {
        if (this.httpClient.version() == HttpClient.Version.HTTP_2) {
            this.upgradeToH2c(target);
        }
    }

    @Override
    public ReactiveHttpClient create(MethodMetadata methodMetadata) {
        Java11ReactiveHttpClient reactiveHttpClient = Java11ReactiveHttpClient.jettyClient(methodMetadata, this.httpClient, this.jsonFactory, this.objectMapper);
        if (this.options != null) {
            if (this.options.getRequestTimeoutMillis() != null) {
                reactiveHttpClient = reactiveHttpClient.setRequestTimeout(this.options.getRequestTimeoutMillis());
            }
            if (this.options.isTryUseCompression() != null) {
                reactiveHttpClient = reactiveHttpClient.setTryUseCompression(this.options.isTryUseCompression());
            }
        }
        return reactiveHttpClient;
    }

    private void upgradeToH2c(Target target) {
        try {
            this.httpClient.send(HttpRequest.newBuilder().method("options", HttpRequest.BodyPublishers.noBody()).uri(URI.create(target.url())).build(), HttpResponse.BodyHandlers.discarding());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

