/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import feign.MethodMetadata;
import org.reactivestreams.Publisher;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StatusHandlerReactiveHttpClient
implements ReactiveHttpClient {
    private final ReactiveHttpClient reactiveClient;
    private final String methodTag;
    private final ReactiveStatusHandler statusHandler;
    private static final ReactiveStatusHandler defaultStatusHandler = ReactiveStatusHandlers.defaultFeignErrorDecoder();

    public static ReactiveHttpClient handleStatus(ReactiveHttpClient reactiveClient, MethodMetadata methodMetadata, ReactiveStatusHandler statusHandler) {
        return new StatusHandlerReactiveHttpClient(reactiveClient, methodMetadata, statusHandler);
    }

    private StatusHandlerReactiveHttpClient(ReactiveHttpClient reactiveClient, MethodMetadata methodMetadata, ReactiveStatusHandler statusHandler) {
        this.reactiveClient = reactiveClient;
        this.methodTag = FeignUtils.methodTag(methodMetadata);
        this.statusHandler = statusHandler;
    }

    @Override
    public Mono<ReactiveHttpResponse> executeRequest(ReactiveHttpRequest request) {
        return this.reactiveClient.executeRequest(request).map(response -> {
            if (this.statusHandler.shouldHandle(response.status())) {
                return new ErrorReactiveHttpResponse((ReactiveHttpResponse)response, this.statusHandler.decode(this.methodTag, (ReactiveHttpResponse)response));
            }
            if (defaultStatusHandler.shouldHandle(response.status())) {
                return new ErrorReactiveHttpResponse((ReactiveHttpResponse)response, defaultStatusHandler.decode(this.methodTag, (ReactiveHttpResponse)response));
            }
            return response;
        });
    }

    private class ErrorReactiveHttpResponse
    extends DelegatingReactiveHttpResponse {
        private final Mono<? extends Throwable> error;

        protected ErrorReactiveHttpResponse(ReactiveHttpResponse response, Mono<? extends Throwable> error) {
            super(response);
            this.error = error;
        }

        public Publisher<Object> body() {
            if (this.getResponse().body() instanceof Mono) {
                return this.error.flatMap(Mono::error);
            }
            return this.error.flatMapMany(Flux::error);
        }
    }
}

