/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import feign.Util;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class ReactiveHttpRequest {
    private final String method;
    private final URI uri;
    private final Map<String, List<String>> headers;
    private final Publisher<Object> body;

    public ReactiveHttpRequest(String method2, URI uri, Map<String, List<String>> headers2, Publisher<Object> body2) {
        this.method = Util.checkNotNull(method2, "method of %s", uri);
        this.uri = Util.checkNotNull(uri, "url", new Object[0]);
        this.headers = Util.checkNotNull(headers2, "headers of %s %s", method2, uri);
        this.body = body2;
    }

    public ReactiveHttpRequest(ReactiveHttpRequest request, Publisher<Object> body2) {
        this(request.method, request.uri, request.headers, body2);
    }

    public String method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Publisher<Object> body() {
        return this.body;
    }
}

