/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Set;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

class ToStringVisitor
implements RouterFunctions.Visitor,
RequestPredicates.Visitor {
    private final StringBuilder builder = new StringBuilder();
    private int indent = 0;
    @Nullable
    private String infix;

    ToStringVisitor() {
    }

    @Override
    public void startNested(RequestPredicate predicate) {
        this.indent();
        predicate.accept(this);
        this.builder.append(" => {\n");
        ++this.indent;
    }

    @Override
    public void endNested(RequestPredicate predicate) {
        --this.indent;
        this.indent();
        this.builder.append("}\n");
    }

    @Override
    public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
        this.indent();
        predicate.accept(this);
        this.builder.append(" -> ");
        this.builder.append(handlerFunction).append('\n');
    }

    @Override
    public void resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        this.indent();
        this.builder.append(lookupFunction).append('\n');
    }

    @Override
    public void unknown(RouterFunction<?> routerFunction) {
        this.indent();
        this.builder.append(routerFunction);
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.builder.append(' ');
        }
    }

    @Override
    public void method(Set<HttpMethod> methods) {
        if (methods.size() == 1) {
            this.builder.append((Object)methods.iterator().next());
        } else {
            this.builder.append(methods);
        }
        this.infix();
    }

    @Override
    public void path(String pattern) {
        this.builder.append(pattern);
        this.infix();
    }

    @Override
    public void pathExtension(String extension) {
        this.builder.append(String.format("*.%s", extension));
        this.infix();
    }

    @Override
    public void header(String name, String value) {
        this.builder.append(String.format("%s: %s", name, value));
        this.infix();
    }

    @Override
    public void queryParam(String name, String value) {
        this.builder.append(String.format("?%s == %s", name, value));
        this.infix();
    }

    @Override
    public void startAnd() {
        this.builder.append('(');
        this.infix = "&&";
    }

    @Override
    public void endAnd() {
        this.builder.append(')');
    }

    @Override
    public void startOr() {
        this.builder.append('(');
        this.infix = "||";
    }

    @Override
    public void endOr() {
        this.builder.append(')');
    }

    @Override
    public void startNegate() {
        this.builder.append("!(");
    }

    @Override
    public void endNegate() {
        this.builder.append(')');
    }

    @Override
    public void unknown(RequestPredicate predicate) {
        this.builder.append(predicate);
    }

    private void infix() {
        if (this.infix != null) {
            this.builder.append(' ');
            this.builder.append(this.infix);
            this.builder.append(' ');
            this.infix = null;
        }
    }

    public String toString() {
        String result = this.builder.toString();
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

