/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Flux;

final class DefaultClientResponseBuilder
implements ClientResponse.Builder {
    private ExchangeStrategies strategies;
    private HttpStatus statusCode = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap<String, ResponseCookie>();
    private Flux<DataBuffer> body = Flux.empty();

    public DefaultClientResponseBuilder(ExchangeStrategies strategies) {
        Assert.notNull((Object)strategies, "ExchangeStrategies must not be null");
        this.strategies = strategies;
    }

    public DefaultClientResponseBuilder(ClientResponse other) {
        Assert.notNull((Object)other, "ClientResponse must not be null");
        this.strategies = other.strategies();
        this.statusCode(other.statusCode());
        this.headers(headers2 -> headers2.addAll(other.headers().asHttpHeaders()));
        this.cookies(cookies -> cookies.addAll(other.cookies()));
    }

    @Override
    public DefaultClientResponseBuilder statusCode(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode, "HttpStatus must not be null");
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public ClientResponse.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ClientResponse.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public DefaultClientResponseBuilder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add(name, ResponseCookie.from(name, value).build());
        }
        return this;
    }

    @Override
    public ClientResponse.Builder cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ClientResponse.Builder body(Flux<DataBuffer> body2) {
        Assert.notNull(body2, "Body must not be null");
        this.releaseBody();
        this.body = body2;
        return this;
    }

    @Override
    public ClientResponse.Builder body(String body2) {
        Assert.notNull((Object)body2, "Body must not be null");
        this.releaseBody();
        DefaultDataBufferFactory dataBufferFactory = new DefaultDataBufferFactory();
        this.body = Flux.just(body2).map(s -> {
            byte[] bytes = body2.getBytes(StandardCharsets.UTF_8);
            return dataBufferFactory.wrap(bytes);
        });
        return this;
    }

    private void releaseBody() {
        this.body.subscribe(DataBufferUtils.releaseConsumer());
    }

    @Override
    public ClientResponse build() {
        BuiltClientHttpResponse httpResponse = new BuiltClientHttpResponse(this.statusCode, this.headers, this.cookies, this.body);
        return new DefaultClientResponse(httpResponse, this.strategies, "");
    }

    private static class BuiltClientHttpResponse
    implements ClientHttpResponse {
        private final HttpStatus statusCode;
        private final HttpHeaders headers;
        private final MultiValueMap<String, ResponseCookie> cookies;
        private final Flux<DataBuffer> body;

        public BuiltClientHttpResponse(HttpStatus statusCode, HttpHeaders headers2, MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body2) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders(headers2);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(cookies);
            this.body = body2;
        }

        @Override
        public HttpStatus getStatusCode() {
            return this.statusCode;
        }

        @Override
        public int getRawStatusCode() {
            return this.statusCode.value();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, ResponseCookie> getCookies() {
            return this.cookies;
        }

        @Override
        public Flux<DataBuffer> getBody() {
            return this.body;
        }
    }
}

