/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    @Nullable
    private ReactiveRequest reactiveRequest;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public HttpMethod getMethod() {
        HttpMethod method2 = HttpMethod.resolve(this.jettyRequest.getMethod());
        Assert.state(method2 != null, "Method must not be null");
        return method2;
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(this::completes);
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        Flux<ContentChunk> chunks = Flux.from(body2).map(this::toContentChunk);
        ReactiveRequest.Content content = ReactiveRequest.Content.fromPublisher(chunks, this.getContentType());
        this.reactiveRequest = ReactiveRequest.newBuilder(this.jettyRequest).content(content).build();
        return this.doCommit(this::completes);
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        Flux<ContentChunk> chunks = Flux.from(body2).flatMap(Function.identity()).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release).map(this::toContentChunk);
        ReactiveRequest.Content content = ReactiveRequest.Content.fromPublisher(chunks, this.getContentType());
        this.reactiveRequest = ReactiveRequest.newBuilder(this.jettyRequest).content(content).build();
        return this.doCommit(this::completes);
    }

    private String getContentType() {
        MediaType contentType2 = this.getHeaders().getContentType();
        return contentType2 != null ? contentType2.toString() : "application/octet-stream";
    }

    private Mono<Void> completes() {
        return Mono.empty();
    }

    private ContentChunk toContentChunk(final DataBuffer buffer) {
        return new ContentChunk(buffer.asByteBuffer(), new Callback(){

            @Override
            public void succeeded() {
                DataBufferUtils.release(buffer);
            }

            @Override
            public void failed(Throwable x) {
                DataBufferUtils.release(buffer);
                throw Exceptions.propagate(x);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(this.jettyRequest::cookie);
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers2 = this.getHeaders();
        headers2.forEach((key, value) -> value.forEach(v -> this.jettyRequest.header((String)key, (String)v)));
        if (!headers2.containsKey("Accept")) {
            this.jettyRequest.header("Accept", "*/*");
        }
    }

    ReactiveRequest getReactiveRequest() {
        if (this.reactiveRequest == null) {
            this.reactiveRequest = ReactiveRequest.newBuilder(this.jettyRequest).build();
        }
        return this.reactiveRequest;
    }
}

