/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;

public class BufferingProcessor
extends AbstractSingleProcessor<ContentChunk, String> {
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private final ReactiveResponse response;

    public BufferingProcessor(ReactiveResponse response) {
        this.response = response;
    }

    @Override
    public void onNext(ContentChunk chunk) {
        ByteBuffer buffer = chunk.buffer;
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.buffers.add(bytes);
        chunk.callback.succeeded();
        this.upStreamRequest(1L);
    }

    @Override
    public void onComplete() {
        int length = this.buffers.stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
        byte[] bytes2 = new byte[length];
        int offset = 0;
        for (byte[] b : this.buffers) {
            int l = b.length;
            System.arraycopy(b, 0, bytes2, offset, l);
            offset += l;
        }
        String encoding = this.response.getEncoding();
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        this.downStreamOnNext(new String(bytes2, Charset.forName(encoding)));
        super.onComplete();
    }
}

