/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtils {
    private static final String QUERY_RESERVED_CHARACTERS = "?/,=";
    private static final String PATH_RESERVED_CHARACTERS = "/=@:!$&'(),;~";
    private static final Pattern PCT_ENCODED_PATTERN = Pattern.compile("%[0-9A-Fa-f][0-9A-Fa-f]");

    public static boolean isEncoded(String value) {
        return PCT_ENCODED_PATTERN.matcher(value).matches();
    }

    public static String encode(String value) {
        return UriUtils.encodeReserved(value, "", Util.UTF_8);
    }

    public static String encode(String value, Charset charset) {
        return UriUtils.encodeReserved(value, "", charset);
    }

    public static String decode(String value, Charset charset) {
        try {
            return URLDecoder.decode(value, charset.name());
        }
        catch (UnsupportedEncodingException uee) {
            return value;
        }
    }

    public static String pathEncode(String path2, Charset charset) {
        return UriUtils.encodeReserved(path2, PATH_RESERVED_CHARACTERS, charset);
    }

    public static String queryEncode(String query, Charset charset) {
        return UriUtils.encodeReserved(query, QUERY_RESERVED_CHARACTERS, charset);
    }

    public static boolean isAbsolute(String uri) {
        return uri != null && !uri.isEmpty() && uri.startsWith("http");
    }

    private static String urlEncode(String value, Charset charset) {
        try {
            String encoded = URLEncoder.encode(value, charset.toString());
            return encoded.replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~").replaceAll("\\%2B", "+");
        }
        catch (UnsupportedEncodingException uee) {
            return value;
        }
    }

    public static String encodeReserved(String value, String reserved, Charset charset) {
        Matcher matcher = PCT_ENCODED_PATTERN.matcher(value);
        if (!matcher.find()) {
            return UriUtils.encodeChunk(value, reserved, charset);
        }
        int length = value.length();
        StringBuilder encoded = new StringBuilder(length + 8);
        int index = 0;
        do {
            String before = value.substring(index, matcher.start());
            encoded.append(UriUtils.encodeChunk(before, reserved, charset));
            encoded.append(matcher.group());
            index = matcher.end();
        } while (matcher.find());
        String tail = value.substring(index, length);
        encoded.append(UriUtils.encodeChunk(tail, reserved, charset));
        return encoded.toString();
    }

    private static String encodeChunk(String value, String reserved, Charset charset) {
        StringBuilder encoded = null;
        int length = value.length();
        int index = 0;
        for (int i = 0; i < length; ++i) {
            char character = value.charAt(i);
            if (reserved.indexOf(character) == -1) continue;
            if (encoded == null) {
                encoded = new StringBuilder(length + 8);
            }
            if (i != index) {
                encoded.append(UriUtils.urlEncode(value.substring(index, i), charset));
            }
            encoded.append(character);
            index = i + 1;
        }
        if (encoded == null) {
            return UriUtils.urlEncode(value, charset);
        }
        if (index < length) {
            encoded.append(UriUtils.urlEncode(value.substring(index, length), charset));
        }
        return encoded.toString();
    }
}

