/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.List;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxMetrics;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoMetrics;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;

final class MonoMetricsFuseable<T>
extends MonoOperator<T, T>
implements Fuseable {
    final String name;
    final List<Tag> tags;
    @Nullable
    final MeterRegistry registryCandidate;

    MonoMetricsFuseable(Mono<? extends T> mono) {
        this(mono, null);
    }

    MonoMetricsFuseable(Mono<? extends T> mono, @Nullable MeterRegistry registryCandidate) {
        super(mono);
        Tuple2<String, List<Tag>> nameAndTags = FluxMetrics.resolveNameAndTags(mono);
        this.name = nameAndTags.getT1();
        this.tags = nameAndTags.getT2();
        this.registryCandidate = registryCandidate;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        CompositeMeterRegistry registry = Metrics.globalRegistry;
        if (this.registryCandidate != null) {
            registry = this.registryCandidate;
        }
        this.source.subscribe(new MonoMetrics.MicrometerMonoMetricsFuseableSubscriber<T>(actual, (MeterRegistry)registry, Clock.SYSTEM, this.name, this.tags));
    }
}

