/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.log;

import java.time.Clock;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.utils.Pair;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveLogger
implements ReactiveLoggerListener<LogContext> {
    private final Logger logger = LoggerFactory.getLogger(DefaultReactiveLogger.class);
    private final Clock clock;

    public DefaultReactiveLogger(Clock clock) {
        this.clock = clock;
    }

    @Override
    public LogContext requestStarted(ReactiveHttpRequest request, String feignMethodTag) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]--->{} {} HTTP/1.1", feignMethodTag, request.method(), request.uri());
        }
        if (this.logger.isTraceEnabled()) {
            this.logRequestHeaders(request, feignMethodTag);
        }
        return new LogContext(this.clock);
    }

    @Override
    public boolean logRequestBody() {
        return this.logger.isTraceEnabled();
    }

    private void logRequestHeaders(ReactiveHttpRequest request, String feignMethodTag) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] REQUEST HEADERS\n{}", (Object)feignMethodTag, (Object)DefaultReactiveLogger.msg(() -> request.headers().entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"))));
        }
    }

    @Override
    public void bodySent(ReactiveHttpRequest request, String feignMethodTag, LogContext logContext, Object body2) {
        if (this.logger.isTraceEnabled()) {
            if (request.body() instanceof Mono) {
                this.logger.trace("[{}] REQUEST BODY\n{}", (Object)feignMethodTag, body2);
            } else if (request.body() instanceof Flux) {
                this.logger.trace("[{}] REQUEST BODY ELEMENT\n{}", (Object)feignMethodTag, body2);
            } else {
                throw new IllegalArgumentException("Unsupported publisher type: " + request.body().getClass());
            }
        }
    }

    @Override
    public void responseReceived(ReactiveHttpResponse response, String feignMethodTag, LogContext logContext) {
        this.logResponseHeaders(response, feignMethodTag, logContext.timeSpent());
    }

    @Override
    public boolean logResponseBody() {
        return this.logger.isTraceEnabled();
    }

    private void logResponseHeaders(ReactiveHttpResponse httpResponse, String feignMethodTag, long elapsedTime) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] RESPONSE HEADERS\n{}", (Object)feignMethodTag, (Object)DefaultReactiveLogger.msg(() -> httpResponse.headers().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new Pair<String, String>((String)entry.getKey(), (String)value))).map(pair -> String.format("%s:%s", pair.left, pair.right)).collect(Collectors.joining("\n"))));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- headers takes {} milliseconds", (Object)feignMethodTag, (Object)elapsedTime);
        }
    }

    @Override
    public void bodyReceived(ReactiveHttpResponse response, String feignMethodTag, LogContext logContext, Object body2) {
        if (this.logger.isTraceEnabled()) {
            if (response.body() instanceof Mono) {
                this.logger.trace("[{}] RESPONSE BODY\n{}", (Object)feignMethodTag, body2);
            } else {
                this.logger.trace("[{}] RESPONSE BODY ELEMENT\n{}", (Object)feignMethodTag, body2);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- body takes {} milliseconds", (Object)feignMethodTag, (Object)logContext.timeSpent());
        }
    }

    private static MessageSupplier msg(Supplier<?> supplier) {
        return new MessageSupplier(supplier);
    }

    static class MessageSupplier {
        private Supplier<?> supplier;

        public MessageSupplier(Supplier<?> supplier) {
            this.supplier = supplier;
        }

        public String toString() {
            return this.supplier.get().toString();
        }
    }

    static class LogContext {
        private final Clock clock;
        private final long startTime;

        public LogContext(Clock clock) {
            this.clock = clock;
            this.startTime = clock.millis();
        }

        public long timeSpent() {
            return this.clock.millis() - this.startTime;
        }
    }
}

