/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.result.condition.AbstractMediaTypeExpression;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.HeadersRequestCondition;
import org.springframework.web.reactive.result.condition.MediaTypeExpression;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private static final ProducesRequestCondition PRE_FLIGHT_MATCH = new ProducesRequestCondition(new String[0]);
    private final List<ProduceMediaTypeExpression> mediaTypeAllList = Collections.singletonList(new ProduceMediaTypeExpression("*/*"));
    private final List<ProduceMediaTypeExpression> expressions;
    private final RequestedContentTypeResolver contentTypeResolver;

    public ProducesRequestCondition(String ... produces) {
        this(produces, (String[])null);
    }

    public ProducesRequestCondition(String[] produces, String[] headers2) {
        this(produces, headers2, (RequestedContentTypeResolver)null);
    }

    public ProducesRequestCondition(String[] produces, String[] headers2, RequestedContentTypeResolver resolver) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(this.parseExpressions(produces, headers2));
        Collections.sort(this.expressions);
        this.contentTypeResolver = resolver != null ? resolver : new HeaderContentTypeResolver();
    }

    private ProducesRequestCondition(Collection<ProduceMediaTypeExpression> expressions, RequestedContentTypeResolver resolver) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
        this.contentTypeResolver = resolver != null ? resolver : new RequestedContentTypeResolverBuilder().build();
    }

    private Set<ProduceMediaTypeExpression> parseExpressions(String[] produces, String[] headers2) {
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>();
        if (headers2 != null) {
            for (String header : headers2) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expr.name)) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)expr.value)) {
                    result.add(new ProduceMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (produces != null) {
            for (String produce : produces) {
                result.add(new ProduceMediaTypeExpression(produce));
            }
        }
        return result;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getProducibleMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected List<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    @Nullable
    public ProducesRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        if (CorsUtils.isPreFlightRequest(exchange2.getRequest())) {
            return PRE_FLIGHT_MATCH;
        }
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>(this.expressions);
        result.removeIf(expression -> !expression.match(exchange2));
        return !result.isEmpty() ? new ProducesRequestCondition(result, this.contentTypeResolver) : null;
    }

    @Override
    public int compareTo(ProducesRequestCondition other, ServerWebExchange exchange2) {
        try {
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(exchange2);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
                int result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
                if (result != 0) {
                    return result;
                }
                thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
                result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (NotAcceptableStatusException ex) {
            throw new IllegalStateException("Cannot compare without having any requested media types", ex);
        }
    }

    private List<MediaType> getAcceptedMediaTypes(ServerWebExchange exchange2) throws NotAcceptableStatusException {
        return this.contentTypeResolver.resolveMediaTypes(exchange2);
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        for (int i = 0; i < this.getExpressionsToCompare().size(); ++i) {
            MediaType currentMediaType = this.getExpressionsToCompare().get(i).getMediaType();
            if (!mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) || !mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        for (int i = 0; i < this.getExpressionsToCompare().size(); ++i) {
            if (!mediaType.includes(this.getExpressionsToCompare().get(i).getMediaType())) continue;
            return i;
        }
        return -1;
    }

    private int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1) {
            ProduceMediaTypeExpression expr2;
            ProduceMediaTypeExpression expr1 = condition1.getExpressionsToCompare().get(index1);
            result = expr1.compareTo(expr2 = condition2.getExpressionsToCompare().get(index2));
            result = result != 0 ? result : expr1.getMediaType().compareTo(expr2.getMediaType());
        }
        return result;
    }

    private List<ProduceMediaTypeExpression> getExpressionsToCompare() {
        return this.expressions.isEmpty() ? this.mediaTypeAllList : this.expressions;
    }

    class ProduceMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceMediaTypeExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean matchMediaType(ServerWebExchange exchange2) throws NotAcceptableStatusException {
            List acceptedMediaTypes = ProducesRequestCondition.this.getAcceptedMediaTypes(exchange2);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!this.getMediaType().isCompatibleWith(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }
    }
}

