/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.client.HttpStatusCodeException;

public class HttpServerErrorException
extends HttpStatusCodeException {
    private static final long serialVersionUID = -2915754006618138282L;

    public HttpServerErrorException(HttpStatus statusCode) {
        super(statusCode);
    }

    public HttpServerErrorException(HttpStatus statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpServerErrorException(HttpStatus statusCode, String statusText, @Nullable byte[] body2, @Nullable Charset charset) {
        super(statusCode, statusText, body2, charset);
    }

    public HttpServerErrorException(HttpStatus statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] body2, @Nullable Charset charset) {
        super(statusCode, statusText, headers2, body2, charset);
    }

    public static HttpServerErrorException create(HttpStatus statusCode, String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
        switch (statusCode) {
            case INTERNAL_SERVER_ERROR: {
                return new InternalServerError(statusText, headers2, body2, charset);
            }
            case NOT_IMPLEMENTED: {
                return new NotImplemented(statusText, headers2, body2, charset);
            }
            case BAD_GATEWAY: {
                return new BadGateway(statusText, headers2, body2, charset);
            }
            case SERVICE_UNAVAILABLE: {
                return new ServiceUnavailable(statusText, headers2, body2, charset);
            }
            case GATEWAY_TIMEOUT: {
                return new GatewayTimeout(statusText, headers2, body2, charset);
            }
        }
        return new HttpServerErrorException(statusCode, statusText, headers2, body2, charset);
    }

    public static class GatewayTimeout
    extends HttpServerErrorException {
        GatewayTimeout(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.GATEWAY_TIMEOUT, statusText, headers2, body2, charset);
        }
    }

    public static class ServiceUnavailable
    extends HttpServerErrorException {
        ServiceUnavailable(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.SERVICE_UNAVAILABLE, statusText, headers2, body2, charset);
        }
    }

    public static class BadGateway
    extends HttpServerErrorException {
        BadGateway(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.BAD_GATEWAY, statusText, headers2, body2, charset);
        }
    }

    public static class NotImplemented
    extends HttpServerErrorException {
        NotImplemented(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.NOT_IMPLEMENTED, statusText, headers2, body2, charset);
        }
    }

    public static class InternalServerError
    extends HttpServerErrorException {
        InternalServerError(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.INTERNAL_SERVER_ERROR, statusText, headers2, body2, charset);
        }
    }
}

