/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.FormHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipartHttpMessageWriter
extends LoggingCodecSupport
implements HttpMessageWriter<MultiValueMap<String, ?>> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Map<String, Object> DEFAULT_HINTS = Hints.from(Hints.SUPPRESS_LOGGING_HINT, true);
    private final List<HttpMessageWriter<?>> partWriters;
    @Nullable
    private final HttpMessageWriter<MultiValueMap<String, String>> formWriter;
    private Charset charset = DEFAULT_CHARSET;
    private final List<MediaType> supportedMediaTypes;
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public MultipartHttpMessageWriter() {
        this(Arrays.asList(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()), new ResourceHttpMessageWriter()));
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters) {
        this(partWriters, new FormHttpMessageWriter());
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters, @Nullable HttpMessageWriter<MultiValueMap<String, String>> formWriter) {
        this.partWriters = partWriters;
        this.formWriter = formWriter;
        this.supportedMediaTypes = MultipartHttpMessageWriter.initMediaTypes(formWriter);
    }

    private static List<MediaType> initMediaTypes(@Nullable HttpMessageWriter<?> formWriter) {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        result.add(MediaType.MULTIPART_FORM_DATA);
        if (formWriter != null) {
            result.addAll(formWriter.getWritableMediaTypes());
        }
        return Collections.unmodifiableList(result);
    }

    public List<HttpMessageWriter<?>> getPartWriters() {
        return Collections.unmodifiableList(this.partWriters);
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return this.supportedMediaTypes;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        return MultiValueMap.class.isAssignableFrom(elementType.toClass()) && (mediaType == null || this.supportedMediaTypes.stream().anyMatch(element -> element.isCompatibleWith(mediaType)));
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, ?>> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        return Mono.from(inputStream).flatMap(map -> {
            if (this.formWriter == null || this.isMultipart((MultiValueMap<String, ?>)map, mediaType)) {
                return this.writeMultipart((MultiValueMap<String, ?>)map, outputMessage, hints);
            }
            MultiValueMap formData = map;
            return this.formWriter.write(Mono.just(formData), elementType, mediaType, outputMessage, hints);
        });
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, @Nullable MediaType contentType2) {
        if (contentType2 != null) {
            return MediaType.MULTIPART_FORM_DATA.includes(contentType2);
        }
        for (String name : map.keySet()) {
            for (Object value : (List)map.get(name)) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private Mono<Void> writeMultipart(MultiValueMap<String, ?> map, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("boundary", new String(boundary, StandardCharsets.US_ASCII));
        params.put("charset", this.getCharset().name());
        outputMessage.getHeaders().setContentType(new MediaType(MediaType.MULTIPART_FORM_DATA, params));
        LogFormatUtils.traceDebug(this.logger, traceOn -> Hints.getLogPrefix(hints) + "Encoding " + (this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue(map, traceOn == false) : "parts " + map.keySet() + " (content masked)"));
        Flux<DataBuffer> body2 = Flux.fromIterable(map.entrySet()).concatMap(entry -> this.encodePartValues(boundary, (String)entry.getKey(), (List)entry.getValue())).concatWith(Mono.just(this.generateLastLine(boundary)));
        return outputMessage.writeWith(body2);
    }

    protected byte[] generateMultipartBoundary() {
        return MimeTypeUtils.generateMultipartBoundary();
    }

    private Flux<DataBuffer> encodePartValues(byte[] boundary, String name, List<?> values) {
        return Flux.concat(values.stream().map(v -> this.encodePart(boundary, name, v)).collect(Collectors.toList()));
    }

    private <T> Flux<DataBuffer> encodePart(byte[] boundary, String name, T value) {
        Object body2;
        MultipartHttpOutputMessage outputMessage = new MultipartHttpOutputMessage(this.bufferFactory, this.getCharset());
        HttpHeaders outputHeaders = outputMessage.getHeaders();
        ResolvableType resolvableType = null;
        if (value instanceof HttpEntity) {
            HttpEntity httpEntity = (HttpEntity)value;
            outputHeaders.putAll(httpEntity.getHeaders());
            body2 = httpEntity.getBody();
            Assert.state(body2 != null, "MultipartHttpMessageWriter only supports HttpEntity with body");
            if (httpEntity instanceof MultipartBodyBuilder.PublisherEntity) {
                MultipartBodyBuilder.PublisherEntity publisherEntity = (MultipartBodyBuilder.PublisherEntity)httpEntity;
                resolvableType = publisherEntity.getResolvableType();
            }
        } else {
            body2 = value;
        }
        if (resolvableType == null) {
            resolvableType = ResolvableType.forClass(body2.getClass());
        }
        if (!outputHeaders.containsKey("Content-Disposition")) {
            if (body2 instanceof Resource) {
                outputHeaders.setContentDispositionFormData(name, ((Resource)body2).getFilename());
            } else if (resolvableType.resolve() == Resource.class) {
                body2 = Mono.from((Publisher)body2).doOnNext(o -> outputHeaders.setContentDispositionFormData(name, ((Resource)o).getFilename()));
            } else {
                outputHeaders.setContentDispositionFormData(name, null);
            }
        }
        MediaType contentType2 = outputHeaders.getContentType();
        ResolvableType finalBodyType = resolvableType;
        Optional<HttpMessageWriter> writer = this.partWriters.stream().filter(partWriter -> partWriter.canWrite(finalBodyType, contentType2)).findFirst();
        if (!writer.isPresent()) {
            return Flux.error(new CodecException("No suitable writer found for part: " + name));
        }
        Mono<T> bodyPublisher = body2 instanceof Publisher ? (Mono<T>)body2 : Mono.just(body2);
        Mono<Void> partContentReady = writer.get().write(bodyPublisher, resolvableType, contentType2, outputMessage, DEFAULT_HINTS);
        Flux partContent = partContentReady.thenMany(Flux.defer(outputMessage::getBody));
        return Flux.concat(Mono.just(this.generateBoundaryLine(boundary)), partContent, Mono.just(this.generateNewLine()));
    }

    private DataBuffer generateBoundaryLine(byte[] boundary) {
        DataBuffer buffer = this.bufferFactory.allocateBuffer(boundary.length + 4);
        buffer.write((byte)45);
        buffer.write((byte)45);
        buffer.write(boundary);
        buffer.write((byte)13);
        buffer.write((byte)10);
        return buffer;
    }

    private DataBuffer generateNewLine() {
        DataBuffer buffer = this.bufferFactory.allocateBuffer(2);
        buffer.write((byte)13);
        buffer.write((byte)10);
        return buffer;
    }

    private DataBuffer generateLastLine(byte[] boundary) {
        DataBuffer buffer = this.bufferFactory.allocateBuffer(boundary.length + 6);
        buffer.write((byte)45);
        buffer.write((byte)45);
        buffer.write(boundary);
        buffer.write((byte)45);
        buffer.write((byte)45);
        buffer.write((byte)13);
        buffer.write((byte)10);
        return buffer;
    }

    private static class MultipartHttpOutputMessage
    implements ReactiveHttpOutputMessage {
        private final DataBufferFactory bufferFactory;
        private final Charset charset;
        private final HttpHeaders headers = new HttpHeaders();
        private final AtomicBoolean committed = new AtomicBoolean();
        @Nullable
        private Flux<DataBuffer> body;

        public MultipartHttpOutputMessage(DataBufferFactory bufferFactory, Charset charset) {
            this.bufferFactory = bufferFactory;
            this.charset = charset;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.body != null ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
        }

        @Override
        public DataBufferFactory bufferFactory() {
            return this.bufferFactory;
        }

        @Override
        public void beforeCommit(Supplier<? extends Mono<Void>> action) {
            this.committed.set(true);
        }

        @Override
        public boolean isCommitted() {
            return this.committed.get();
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
            if (this.body != null) {
                return Mono.error(new IllegalStateException("Multiple calls to writeWith() not supported"));
            }
            this.body = Flux.just(this.generateHeaders()).concatWith(body2);
            return Mono.empty();
        }

        private DataBuffer generateHeaders() {
            DataBuffer buffer = this.bufferFactory.allocateBuffer();
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                byte[] headerName = entry.getKey().getBytes(this.charset);
                for (String headerValueString : entry.getValue()) {
                    byte[] headerValue = headerValueString.getBytes(this.charset);
                    buffer.write(headerName);
                    buffer.write((byte)58);
                    buffer.write((byte)32);
                    buffer.write(headerValue);
                    buffer.write((byte)13);
                    buffer.write((byte)10);
                }
            }
            buffer.write((byte)13);
            buffer.write((byte)10);
            return buffer;
        }

        @Override
        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
            return Mono.error(new UnsupportedOperationException());
        }

        public Flux<DataBuffer> getBody() {
            return this.body != null ? this.body : Flux.error(new IllegalStateException("Body has not been written yet"));
        }

        @Override
        public Mono<Void> setComplete() {
            return Mono.error(new UnsupportedOperationException());
        }
    }
}

