/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange2, final HttpContent content, final Callback callback) {
        final HttpRequest request = exchange2.getRequest();
        String path2 = this.relativize(request.getPath());
        HttpURI uri = HttpURI.createHttpURI(request.getScheme(), request.getHost(), request.getPort(), path2, null, request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        final Supplier<HttpFields> trailers = request.getTrailers();
        metaData.setTrailerSupplier(trailers);
        HeadersFrame headersFrame = new HeadersFrame(metaData, null, trailers == null && !content.hasContent());
        final HttpChannelOverHTTP2 channel = this.getHttpChannel();
        Promise<Stream> promise = new Promise<Stream>(){

            @Override
            public void succeeded(Stream stream) {
                channel.setStream(stream);
                ((IStream)stream).setAttachment(channel);
                long idleTimeout = request.getIdleTimeout();
                if (idleTimeout >= 0L) {
                    stream.setIdleTimeout(idleTimeout);
                }
                if (content.hasContent() && !HttpSenderOverHTTP2.this.expects100Continue(request)) {
                    boolean lastContent;
                    boolean advanced = content.advance();
                    boolean bl = lastContent = trailers == null && content.isLast();
                    if (advanced || lastContent) {
                        DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), lastContent);
                        stream.data(dataFrame, callback);
                        return;
                    }
                }
                callback.succeeded();
            }

            @Override
            public void failed(Throwable failure) {
                callback.failed(failure);
            }
        };
        channel.getSession().newStream(headersFrame, promise, channel.getStreamListener());
    }

    private String relativize(String path2) {
        try {
            String result = path2;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path2, new Object[0]);
            }
            return path2;
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange2, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            Supplier<HttpFields> trailers = exchange2.getRequest().getTrailers();
            DataFrame frame = new DataFrame(stream.getId(), content.getByteBuffer(), trailers == null && content.isLast());
            stream.data(frame, callback);
        }
    }

    @Override
    protected void sendTrailers(HttpExchange exchange2, Callback callback) {
        Supplier<HttpFields> trailers = exchange2.getRequest().getTrailers();
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers.get());
        Stream stream = this.getHttpChannel().getStream();
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }
}

