/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Retainable;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    private final ContentNotifier contentNotifier = new ContentNotifier();

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void reset() {
        super.reset();
        this.contentNotifier.reset();
    }

    @Override
    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        HttpResponse httpResponse = exchange2.getResponse();
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)frame.getMetaData();
            httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
            if (this.responseBegin(exchange2)) {
                HttpFields headers2 = response.getFields();
                for (HttpField header : headers2) {
                    if (this.responseHeader(exchange2, header)) continue;
                    return;
                }
                if (this.responseHeaders(exchange2)) {
                    boolean informational;
                    int status = response.getStatus();
                    boolean bl = informational = HttpStatus.isInformational(status) && status != 101;
                    if (frame.isEndStream() || informational) {
                        this.responseSuccess(exchange2);
                    }
                }
            }
        } else {
            HttpFields trailers = metaData.getFields();
            trailers.forEach(httpResponse::trailer);
            this.notifyContent(exchange2, new DataFrame(stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
        }
    }

    @Override
    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return null;
        }
        HttpRequest request = exchange2.getRequest();
        MetaData.Request metaData = (MetaData.Request)frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getURIString());
        BiFunction<Request, Request, Response.CompleteListener> pushListener = request.getPushListener();
        if (pushListener != null && (listener = pushListener.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().acquireHttpChannel();
            List<Response.ResponseListener> listeners = Collections.singletonList(listener);
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest, listeners);
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    @Override
    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            callback.failed(new IOException("terminated"));
        } else {
            this.notifyContent(exchange2, frame, callback);
        }
    }

    @Override
    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        int error = frame.getError();
        exchange2.getRequest().abort(new IOException(ErrorCode.toString(error, "reset_code_" + error)));
    }

    @Override
    public boolean onIdleTimeout(Stream stream, Throwable x) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return false;
        }
        return !exchange2.abort(x);
    }

    @Override
    public void onFailure(Stream stream, int error, String reason, Callback callback) {
        this.responseFailure(new IOException(String.format("%s/%s", ErrorCode.toString(error, null), reason)));
        callback.succeeded();
    }

    @Override
    public void onClosed(Stream stream) {
        this.getHttpChannel().onStreamClosed((IStream)stream);
    }

    private void notifyContent(HttpExchange exchange2, DataFrame frame, Callback callback) {
        this.contentNotifier.offer(new DataInfo(exchange2, frame, callback));
        this.contentNotifier.iterate();
    }

    private static class DataInfo {
        private final HttpExchange exchange;
        private final DataFrame frame;
        private final Callback callback;

        private DataInfo(HttpExchange exchange2, DataFrame frame, Callback callback) {
            this.exchange = exchange2;
            this.frame = frame;
            this.callback = callback;
        }
    }

    private class ContentNotifier
    extends IteratingCallback
    implements Retainable {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private DataInfo dataInfo;

        private ContentNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void offer(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IteratingCallback.Action process() {
            DataInfo dataInfo;
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                dataInfo = this.queue.poll();
            }
            if (dataInfo == null) {
                DataInfo prevDataInfo = this.dataInfo;
                if (prevDataInfo != null && prevDataInfo.frame.isEndStream()) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                return IteratingCallback.Action.IDLE;
            }
            this.dataInfo = dataInfo;
            ByteBuffer buffer = dataInfo.frame.getData();
            if (buffer.hasRemaining()) {
                HttpReceiverOverHTTP2.this.responseContent(dataInfo.exchange, buffer, this);
            } else {
                this.succeeded();
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        public void retain() {
            Callback callback = this.dataInfo.callback;
            if (callback instanceof Retainable) {
                ((Retainable)((Object)callback)).retain();
            }
        }

        @Override
        public void succeeded() {
            this.dataInfo.callback.succeeded();
            super.succeeded();
        }

        @Override
        protected void onCompleteSuccess() {
            HttpReceiverOverHTTP2.this.responseSuccess(this.dataInfo.exchange);
        }

        @Override
        protected void onCompleteFailure(Throwable failure) {
            this.dataInfo.callback.failed(failure);
            HttpReceiverOverHTTP2.this.responseFailure(failure);
        }
    }
}

