/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RenderableDate {
    private final Date date;
    private final String format;
    private final String timezoneName;

    public RenderableDate(Date date, String format, String timezone) {
        this.date = date;
        this.format = format;
        this.timezoneName = timezone;
    }

    public String toString() {
        if (this.format != null) {
            return this.format.equals("epoch") ? String.valueOf(this.date.getTime()) : this.formatCustom();
        }
        return this.timezoneName != null ? ISO8601Utils.format(this.date, false, TimeZone.getTimeZone(this.timezoneName)) : ISO8601Utils.format(this.date, false);
    }

    private String formatCustom() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.format);
        if (this.timezoneName != null) {
            TimeZone zone = TimeZone.getTimeZone(this.timezoneName);
            dateFormat.setTimeZone(zone);
        }
        return dateFormat.format(this.date);
    }
}

