/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.TcpUtils;

public final class ProxyProvider {
    final String username;
    final Function<? super String, ? extends String> password;
    final Supplier<? extends InetSocketAddress> address;
    final Pattern nonProxyHosts;
    final Proxy type;

    public static TypeSpec builder() {
        return new Build();
    }

    ProxyProvider(Build builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.address = Objects.isNull(builder.address) ? () -> InetSocketAddressUtil.createResolved(builder.host, builder.port) : builder.address;
        this.nonProxyHosts = builder.nonProxyHosts != null ? Pattern.compile(builder.nonProxyHosts, 2) : null;
        this.type = builder.type;
    }

    public final Proxy getType() {
        return this.type;
    }

    public final Supplier<? extends InetSocketAddress> getAddress() {
        return this.address;
    }

    public final Pattern getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public final ProxyHandler newProxyHandler() {
        InetSocketAddress proxyAddr = this.address.get();
        String username = this.username;
        String password = Objects.nonNull(username) && Objects.nonNull(this.password) ? this.password.apply(username) : null;
        switch (this.type) {
            case HTTP: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new HttpProxyHandler((SocketAddress)proxyAddr, username, password) : new HttpProxyHandler(proxyAddr);
            }
            case SOCKS4: {
                return Objects.nonNull(username) ? new Socks4ProxyHandler(proxyAddr, username) : new Socks4ProxyHandler(proxyAddr);
            }
            case SOCKS5: {
                return Objects.nonNull(username) && Objects.nonNull(password) ? new Socks5ProxyHandler(proxyAddr, username, password) : new Socks5ProxyHandler(proxyAddr);
            }
        }
        throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
    }

    public boolean shouldProxy(SocketAddress address) {
        SocketAddress addr = address;
        if (address instanceof TcpUtils.SocketAddressSupplier) {
            addr = ((TcpUtils.SocketAddressSupplier)address).get();
        }
        return addr instanceof InetSocketAddress && this.shouldProxy(((InetSocketAddress)addr).getHostString());
    }

    public boolean shouldProxy(@Nullable String hostName) {
        return this.nonProxyHosts == null || hostName == null || !this.nonProxyHosts.matcher(hostName).matches();
    }

    public String asSimpleString() {
        return "proxy=" + (Object)((Object)this.type) + "(" + this.address.get() + ")";
    }

    public String asDetailedString() {
        return "address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHosts + ", type=" + (Object)((Object)this.type);
    }

    public String toString() {
        return "ProxyProvider{" + this.asDetailedString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyProvider that = (ProxyProvider)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.getAddress(), that.getAddress()) && Objects.equals(this.getNonProxyHosts(), that.getNonProxyHosts()) && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.username, this.password, this.getAddress(), this.getNonProxyHosts(), this.getType()});
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public ProxyProvider build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        public Builder address(InetSocketAddress var1);

        public Builder address(Supplier<? extends InetSocketAddress> var1);
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        String username;
        Function<? super String, ? extends String> password;
        String host;
        int port;
        Supplier<? extends InetSocketAddress> address;
        String nonProxyHosts;
        Proxy type;

        Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> InetSocketAddressUtil.replaceWithResolved(address);
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            this.nonProxyHosts = nonProxyHostsPattern;
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public ProxyProvider build() {
            return new ProxyProvider(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

