/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxMetrics;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;

final class MonoMetrics<T>
extends MonoOperator<T, T> {
    final String name;
    final List<Tag> tags;
    final MeterRegistry meterRegistry;

    MonoMetrics(Mono<? extends T> mono) {
        this(mono, null);
    }

    MonoMetrics(Mono<? extends T> mono, @Nullable MeterRegistry meterRegistry) {
        super(mono);
        Tuple2<String, List<Tag>> nameAndTags = FluxMetrics.resolveNameAndTags(mono);
        this.name = nameAndTags.getT1();
        this.tags = nameAndTags.getT2();
        this.meterRegistry = meterRegistry == null ? Metrics.globalRegistry : meterRegistry;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new MicrometerMonoMetricsSubscriber<T>(actual, this.meterRegistry, Clock.SYSTEM, this.name, this.tags));
    }

    static final class MicrometerMonoMetricsFuseableSubscriber<T>
    extends MicrometerMonoMetricsSubscriber<T>
    implements Fuseable,
    Fuseable.QueueSubscription<T> {
        private int mode;

        MicrometerMonoMetricsFuseableSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, String sequenceName, List<Tag> sequenceTags) {
            super(actual, registry, clock, sequenceName, sequenceTags);
        }

        @Override
        public void onNext(T t) {
            super.onNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            if (this.qs != null) {
                this.mode = this.qs.requestFusion(mode);
                return this.mode;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            if (this.qs == null) {
                return null;
            }
            try {
                Object v = this.qs.poll();
                if (v == null && this.mode == 1) {
                    this.subscribeToTerminateSample.stop(this.subscribeToCompleteTimer);
                }
                return (T)v;
            }
            catch (Throwable e) {
                Timer timer = (Timer)this.subscribeToErrorTimerFactory.apply(e);
                this.subscribeToTerminateSample.stop(timer);
                throw e;
            }
        }

        @Override
        public void clear() {
            if (this.qs != null) {
                this.qs.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.qs == null || this.qs.isEmpty();
        }

        @Override
        public int size() {
            return this.qs == null ? 0 : this.qs.size();
        }
    }

    static class MicrometerMonoMetricsSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Clock clock;
        final Counter malformedSourceCounter;
        final Counter subscribedCounter;
        Timer.Sample subscribeToTerminateSample;
        boolean done;
        @Nullable
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        final Timer subscribeToCompleteTimer;
        final Timer subscribeToCancelTimer;
        final Function<Throwable, Timer> subscribeToErrorTimerFactory;

        MicrometerMonoMetricsSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, String sequenceName, List<Tag> sequenceTags) {
            this.actual = actual;
            this.clock = clock;
            ArrayList<Tag> commonTags = new ArrayList<Tag>();
            commonTags.add(Tag.of((String)"flow", (String)sequenceName));
            commonTags.add(Tag.of((String)"type", (String)"Mono"));
            commonTags.addAll(sequenceTags);
            this.subscribeToCompleteTimer = Timer.builder((String)"reactor.flow.duration").tags(commonTags).tag("status", "completed").tag("exception", "").description("Times the duration elapsed between a subscription and the onComplete termination of the sequence").register(registry);
            this.subscribeToCancelTimer = Timer.builder((String)"reactor.flow.duration").tags(commonTags).tag("status", "cancelled").tag("exception", "").description("Times the duration elapsed between a subscription and the cancellation of the sequence").register(registry);
            Timer.Builder subscribeToErrorTimerBuilder = Timer.builder((String)"reactor.flow.duration").tags(commonTags).tag("status", "error").description("Times the duration elapsed between a subscription and the onError termination of the sequence, with the exception name as a tag.");
            this.subscribeToErrorTimerFactory = e -> subscribeToErrorTimerBuilder.tag("exception", e.getClass().getName()).register(registry);
            this.subscribedCounter = Counter.builder((String)"reactor.subscribed").tags(commonTags).baseUnit("subscribers").description("Counts how many Reactor sequences have been subscribed to").register(registry);
            this.malformedSourceCounter = registry.counter("reactor.malformed.source", commonTags);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                this.malformedSourceCounter.increment();
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                this.malformedSourceCounter.increment();
                Operators.onErrorDropped(e, this.actual.currentContext());
                return;
            }
            this.done = true;
            Timer timer = this.subscribeToErrorTimerFactory.apply(e);
            this.subscribeToTerminateSample.stop(timer);
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                this.malformedSourceCounter.increment();
                return;
            }
            this.done = true;
            this.subscribeToTerminateSample.stop(this.subscribeToCompleteTimer);
            this.actual.onComplete();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.subscribedCounter.increment();
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                if (s instanceof Fuseable.QueueSubscription) {
                    this.qs = (Fuseable.QueueSubscription)s;
                }
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void request(long l) {
            if (Operators.validate(l)) {
                this.s.request(l);
            }
        }

        @Override
        public void cancel() {
            this.subscribeToTerminateSample.stop(this.subscribeToCancelTimer);
            this.s.cancel();
        }
    }
}

