/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import reactivefeign.ReactiveOptions;

public class WebReactiveOptions
extends ReactiveOptions {
    private final Long readTimeoutMillis;
    private final Long writeTimeoutMillis;

    private WebReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Long readTimeoutMillis, Long writeTimeoutMillis, Boolean tryUseCompression) {
        super(useHttp2, connectTimeoutMillis, tryUseCompression);
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public Long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.readTimeoutMillis == null && this.writeTimeoutMillis == null;
    }

    public static class Builder
    extends ReactiveOptions.Builder {
        private Long readTimeoutMillis;
        private Long writeTimeoutMillis;

        public Builder setReadTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setWriteTimeoutMillis(long writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        @Override
        public WebReactiveOptions build() {
            return new WebReactiveOptions(this.useHttp2, this.connectTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.acceptCompressed);
        }
    }
}

