/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.WebReactiveOptions;
import reactivefeign.webclient.client.WebReactiveHttpClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

public class WebReactiveFeign {
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_WRITE_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(WebClient webClient) {
        return new Builder(webClient);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected WebClient webClient;

        protected Builder() {
            this(WebClient.create());
        }

        protected Builder(WebClient webClient) {
            this.setWebClient(webClient);
            this.options(new WebReactiveOptions.Builder().setReadTimeoutMillis(10000L).setWriteTimeoutMillis(10000L).setConnectTimeoutMillis(5000L).build());
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            if (!options.isEmpty()) {
                WebReactiveOptions webOptions = (WebReactiveOptions)options;
                TcpClient tcpClient = TcpClient.create();
                if (options.getConnectTimeoutMillis() != null) {
                    tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, options.getConnectTimeoutMillis().intValue());
                }
                tcpClient = tcpClient.doOnConnected(connection -> {
                    if (webOptions.getReadTimeoutMillis() != null) {
                        connection.addHandlerLast(new ReadTimeoutHandler(webOptions.getReadTimeoutMillis(), TimeUnit.MILLISECONDS));
                    }
                    if (webOptions.getWriteTimeoutMillis() != null) {
                        connection.addHandlerLast(new WriteTimeoutHandler(webOptions.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS));
                    }
                });
                HttpClient httpClient = HttpClient.from(tcpClient);
                if (options.isTryUseCompression() != null) {
                    httpClient = httpClient.compress(true);
                }
                ReactorClientHttpConnector connector = new ReactorClientHttpConnector(httpClient);
                this.setWebClient(this.webClient.mutate().clientConnector(connector).build());
            }
            return this;
        }

        protected void setWebClient(WebClient webClient) {
            this.webClient = webClient;
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, webClient));
        }
    }
}

