/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import feign.Feign;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class FeignUtils {
    public static String methodTag(MethodMetadata methodMetadata) {
        return methodMetadata.configKey().substring(0, methodMetadata.configKey().indexOf(40));
    }

    public static Class returnPublisherType(MethodMetadata methodMetadata) {
        Type returnType = methodMetadata.returnType();
        return (Class)((ParameterizedType)returnType).getRawType();
    }

    public static Type returnActualType(MethodMetadata methodMetadata) {
        return Util.resolveLastTypeParameter(methodMetadata.returnType(), FeignUtils.returnPublisherType(methodMetadata));
    }

    public static Type bodyActualType(MethodMetadata methodMetadata) {
        return FeignUtils.getBodyActualType(methodMetadata.bodyType());
    }

    public static Type getBodyActualType(Type bodyType) {
        return Optional.ofNullable(bodyType).map(type -> {
            if (type instanceof ParameterizedType) {
                Class bodyClass = (Class)((ParameterizedType)type).getRawType();
                if (Publisher.class.isAssignableFrom(bodyClass)) {
                    return Util.resolveLastTypeParameter(bodyType, bodyClass);
                }
                return type;
            }
            return type;
        }).orElse(null);
    }

    public static Method findMethodInTarget(Target target, MethodMetadata methodMetadata) {
        return Arrays.stream(target.type().getMethods()).filter(method2 -> Feign.configKey(target.type(), method2).equals(methodMetadata.configKey())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static boolean requestWithBody(MethodMetadata methodMetadata) {
        return methodMetadata.bodyType() != null;
    }

    public static boolean responseWithBody(MethodMetadata methodMetadata) {
        return FeignUtils.returnActualType(methodMetadata) != Void.class;
    }
}

