/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.java11.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayOutputStream;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.eclipse.jetty.reactive.client.internal.QueuedSinglePublisher;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpResponse;
import reactivejson.ReactorObjectReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class Java11ReactiveHttpResponse
implements ReactiveHttpResponse {
    public static final String CHARSET_DELIMITER = ";charset=";
    private final HttpResponse clientResponse;
    private final Publisher<List<ByteBuffer>> contentChunks;
    private final Class returnPublisherType;
    private Class<?> returnActualClass;
    private final ObjectReader objectReader;
    private final JsonFactory jsonFactory;

    Java11ReactiveHttpResponse(HttpResponse clientResponse, Publisher<List<ByteBuffer>> contentChunks, Class returnPublisherType, Class returnActualClass, JsonFactory jsonFactory, ObjectReader objectReader) {
        this.clientResponse = clientResponse;
        this.contentChunks = contentChunks;
        this.returnPublisherType = returnPublisherType;
        this.returnActualClass = returnActualClass;
        this.objectReader = objectReader;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public int status() {
        return this.clientResponse.statusCode();
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.clientResponse.headers().map();
    }

    @Override
    public Publisher<?> body() {
        ReactorObjectReader reactorObjectReader = new ReactorObjectReader(this.jsonFactory);
        Flux<ByteBuffer> content = this.directContent();
        if (this.returnActualClass == ByteBuffer.class) {
            return content;
        }
        if (this.returnActualClass.isAssignableFrom(String.class) && this.returnPublisherType == Mono.class) {
            Charset charset = this.getCharset();
            return content.map(byteBuffer -> charset.decode((ByteBuffer)byteBuffer).toString());
        }
        if (this.returnPublisherType == Mono.class) {
            return reactorObjectReader.read(content, this.objectReader);
        }
        if (this.returnPublisherType == Flux.class) {
            return reactorObjectReader.readElements(content, this.objectReader);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    private Charset getCharset() {
        return Optional.ofNullable(this.headers().get("Content-Type")).map(headers2 -> {
            String header = (String)headers2.get(0);
            int pos = header.indexOf(CHARSET_DELIMITER);
            if (pos >= 0) {
                return header.substring(pos + CHARSET_DELIMITER.length());
            }
            return null;
        }).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    private Flux<ByteBuffer> directContent() {
        return Flux.from(this.contentChunks).concatMap(Flux::fromIterable);
    }

    @Override
    public Mono<byte[]> bodyData() {
        return this.joinChunks();
    }

    private Mono<byte[]> joinChunks() {
        return this.directContent().reduce(new ByteArrayOutputStream(), (baos, byteBuffer) -> {
            int limit = byteBuffer.limit();
            for (int i = byteBuffer.position(); i < limit; ++i) {
                baos.write(byteBuffer.get(i));
            }
            return baos;
        }).map(ByteArrayOutputStream::toByteArray);
    }

    public static class ReactiveBodySubscriber
    implements Flow.Subscriber<List<ByteBuffer>> {
        private Flow.Subscription subscription;
        private QueuedSinglePublisher<List<ByteBuffer>> content = new QueuedSinglePublisher();

        public Flux<List<ByteBuffer>> content() {
            return Flux.from(this.content);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(1L);
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            this.content.offer(item);
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            this.content.fail(throwable);
        }

        @Override
        public void onComplete() {
            this.content.complete();
        }
    }
}

